/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.transform.KeySchemaElementMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KeySchemaElement
implements StructuredPojo,
ToCopyableBuilder<Builder, KeySchemaElement> {
    private final String attributeName;
    private final String keyType;

    private KeySchemaElement(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.keyType = builder.keyType;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public String keyType() {
        return this.keyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributeName() == null ? 0 : this.attributeName().hashCode());
        hashCode = 31 * hashCode + (this.keyType() == null ? 0 : this.keyType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeySchemaElement)) {
            return false;
        }
        KeySchemaElement other = (KeySchemaElement)obj;
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        if (other.keyType() == null ^ this.keyType() == null) {
            return false;
        }
        return other.keyType() == null || other.keyType().equals(this.keyType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (this.keyType() != null) {
            sb.append("KeyType: ").append(this.keyType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeySchemaElementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private String keyType;

        private BuilderImpl() {
        }

        private BuilderImpl(KeySchemaElement model) {
            this.setAttributeName(model.attributeName);
            this.setKeyType(model.keyType);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getKeyType() {
            return this.keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType.toString());
            return this;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        public final void setKeyType(KeyType keyType) {
            this.keyType(keyType.toString());
        }

        public KeySchemaElement build() {
            return new KeySchemaElement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeySchemaElement> {
        public Builder attributeName(String var1);

        public Builder keyType(String var1);

        public Builder keyType(KeyType var1);
    }
}

