/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>BatchWriteItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchWriteItemRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<BatchWriteItemRequest.Builder, BatchWriteItemRequest> {
    private final Map<String, List<WriteRequest>> requestItems;

    private final String returnConsumedCapacity;

    private final String returnItemCollectionMetrics;

    private BatchWriteItemRequest(BuilderImpl builder) {
        this.requestItems = builder.requestItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
    }

    /**
     * <p>
     * A map of one or more table names and, for each table, a list of operations to be performed (
     * <code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to be
     * deleted is identified by a <code>Key</code> subelement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key</code> - A map of primary key attribute values that uniquely identify the ! item. Each entry in this
     * map consists of an attribute name and an attribute value. For each primary key, you must provide <i>all</i> of
     * the key attributes. For example, with a simple primary key, you only need to provide a value for the partition
     * key. For a composite primary key, you must provide values for <i>both</i> the partition key and the sort key.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put is
     * identified by an <code>Item</code> subelement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute name
     * and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths
     * greater than zero; and set type attributes must not be empty. Requests that contain empty values will be rejected
     * with a <code>ValidationException</code> exception.
     * </p>
     * <p>
     * If you specify any attributes that are part of an index key, then the data types for those attributes must match
     * those of the schema in the table's attribute definition.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of one or more table names and, for each table, a list of operations to be performed (
     *         <code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item
     *         to be deleted is identified by a <code>Key</code> subelement:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Key</code> - A map of primary key attribute values that uniquely identify the ! item. Each entry in
     *         this map consists of an attribute name and an attribute value. For each primary key, you must provide
     *         <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide a
     *         value for the partition key. For a composite primary key, you must provide values for <i>both</i> the
     *         partition key and the sort key.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be
     *         put is identified by an <code>Item</code> subelement:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute
     *         name and an attribute value. Attribute values must not be null; string and binary type attributes must
     *         have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty
     *         values will be rejected with a <code>ValidationException</code> exception.
     *         </p>
     *         <p>
     *         If you specify any attributes that are part of an index key, then the data types for those attributes
     *         must match those of the schema in the table's attribute definition.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public Map<String, List<WriteRequest>> requestItems() {
        return requestItems;
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public String returnConsumedCapacity() {
        return returnConsumedCapacity;
    }

    /**
     * <p>
     * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
     * statistics about item collections, if any, that were modified during the operation are returned in the response.
     * If set to <code>NONE</code> (the default), no statistics are returned.
     * </p>
     * 
     * @return Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
     *         includes statistics about item collections, if any, that were modified during the operation are returned
     *         in the response. If set to <code>NONE</code> (the default), no statistics are returned.
     * @see ReturnItemCollectionMetrics
     */
    public String returnItemCollectionMetrics() {
        return returnItemCollectionMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((requestItems() == null) ? 0 : requestItems().hashCode());
        hashCode = 31 * hashCode + ((returnConsumedCapacity() == null) ? 0 : returnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + ((returnItemCollectionMetrics() == null) ? 0 : returnItemCollectionMetrics().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemRequest)) {
            return false;
        }
        BatchWriteItemRequest other = (BatchWriteItemRequest) obj;
        if (other.requestItems() == null ^ this.requestItems() == null) {
            return false;
        }
        if (other.requestItems() != null && !other.requestItems().equals(this.requestItems())) {
            return false;
        }
        if (other.returnConsumedCapacity() == null ^ this.returnConsumedCapacity() == null) {
            return false;
        }
        if (other.returnConsumedCapacity() != null && !other.returnConsumedCapacity().equals(this.returnConsumedCapacity())) {
            return false;
        }
        if (other.returnItemCollectionMetrics() == null ^ this.returnItemCollectionMetrics() == null) {
            return false;
        }
        if (other.returnItemCollectionMetrics() != null
                && !other.returnItemCollectionMetrics().equals(this.returnItemCollectionMetrics())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (requestItems() != null) {
            sb.append("RequestItems: ").append(requestItems()).append(",");
        }
        if (returnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(returnConsumedCapacity()).append(",");
        }
        if (returnItemCollectionMetrics() != null) {
            sb.append("ReturnItemCollectionMetrics: ").append(returnItemCollectionMetrics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchWriteItemRequest> {
        /**
         * <p>
         * A map of one or more table names and, for each table, a list of operations to be performed (
         * <code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to
         * be deleted is identified by a <code>Key</code> subelement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key</code> - A map of primary key attribute values that uniquely identify the ! item. Each entry in
         * this map consists of an attribute name and an attribute value. For each primary key, you must provide
         * <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide a value
         * for the partition key. For a composite primary key, you must provide values for <i>both</i> the partition key
         * and the sort key.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put
         * is identified by an <code>Item</code> subelement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute
         * name and an attribute value. Attribute values must not be null; string and binary type attributes must have
         * lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values will
         * be rejected with a <code>ValidationException</code> exception.
         * </p>
         * <p>
         * If you specify any attributes that are part of an index key, then the data types for those attributes must
         * match those of the schema in the table's attribute definition.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param requestItems
         *        A map of one or more table names and, for each table, a list of operations to be performed (
         *        <code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The
         *        item to be deleted is identified by a <code>Key</code> subelement:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key</code> - A map of primary key attribute values that uniquely identify the ! item. Each entry
         *        in this map consists of an attribute name and an attribute value. For each primary key, you must
         *        provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to
         *        provide a value for the partition key. For a composite primary key, you must provide values for
         *        <i>both</i> the partition key and the sort key.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to
         *        be put is identified by an <code>Item</code> subelement:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an
         *        attribute name and an attribute value. Attribute values must not be null; string and binary type
         *        attributes must have lengths greater than zero; and set type attributes must not be empty. Requests
         *        that contain empty values will be rejected with a <code>ValidationException</code> exception.
         *        </p>
         *        <p>
         *        If you specify any attributes that are part of an index key, then the data types for those attributes
         *        must match those of the schema in the table's attribute definition.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestItems(Map<String, ? extends Collection<WriteRequest>> requestItems);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections, if any, that were modified during the operation are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections, if any, that were modified during the operation are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @see ReturnItemCollectionMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(String returnItemCollectionMetrics);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections, if any, that were modified during the operation are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections, if any, that were modified during the operation are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @see ReturnItemCollectionMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, List<WriteRequest>> requestItems;

        private String returnConsumedCapacity;

        private String returnItemCollectionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteItemRequest model) {
            setRequestItems(model.requestItems);
            setReturnConsumedCapacity(model.returnConsumedCapacity);
            setReturnItemCollectionMetrics(model.returnItemCollectionMetrics);
        }

        public final Map<String, ? extends Collection<WriteRequest>> getRequestItems() {
            return requestItems;
        }

        @Override
        public final Builder requestItems(Map<String, ? extends Collection<WriteRequest>> requestItems) {
            this.requestItems = BatchWriteItemRequestMapCopier.copy(requestItems);
            return this;
        }

        public final void setRequestItems(Map<String, ? extends Collection<WriteRequest>> requestItems) {
            this.requestItems = BatchWriteItemRequestMapCopier.copy(requestItems);
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getReturnItemCollectionMetrics() {
            return returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics.toString());
            return this;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        @Override
        public BatchWriteItemRequest build() {
            return new BatchWriteItemRequest(this);
        }
    }
}
