/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DeleteTable</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteTableResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteTableResponse.Builder, DeleteTableResponse> {
    private final TableDescription tableDescription;

    private DeleteTableResponse(BuilderImpl builder) {
        this.tableDescription = builder.tableDescription;
    }

    /**
     * <p>
     * Represents the properties of a table.
     * </p>
     * 
     * @return Represents the properties of a table.
     */
    public TableDescription tableDescription() {
        return tableDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tableDescription() == null) ? 0 : tableDescription().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTableResponse)) {
            return false;
        }
        DeleteTableResponse other = (DeleteTableResponse) obj;
        if (other.tableDescription() == null ^ this.tableDescription() == null) {
            return false;
        }
        if (other.tableDescription() != null && !other.tableDescription().equals(this.tableDescription())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tableDescription() != null) {
            sb.append("TableDescription: ").append(tableDescription()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteTableResponse> {
        /**
         * <p>
         * Represents the properties of a table.
         * </p>
         * 
         * @param tableDescription
         *        Represents the properties of a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableDescription(TableDescription tableDescription);
    }

    private static final class BuilderImpl implements Builder {
        private TableDescription tableDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTableResponse model) {
            setTableDescription(model.tableDescription);
        }

        public final TableDescription getTableDescription() {
            return tableDescription;
        }

        @Override
        public final Builder tableDescription(TableDescription tableDescription) {
            this.tableDescription = tableDescription;
            return this;
        }

        public final void setTableDescription(TableDescription tableDescription) {
            this.tableDescription = tableDescription;
        }

        @Override
        public DeleteTableResponse build() {
            return new DeleteTableResponse(this);
        }
    }
}
