/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.GlobalSecondaryIndexUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents one of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * A new global secondary index to be added to an existing table.
 * </p>
 * </li>
 * <li>
 * <p>
 * New provisioned throughput parameters for an existing global secondary index.
 * </p>
 * </li>
 * <li>
 * <p>
 * An existing global secondary index to be removed from an existing table.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class GlobalSecondaryIndexUpdate implements StructuredPojo,
        ToCopyableBuilder<GlobalSecondaryIndexUpdate.Builder, GlobalSecondaryIndexUpdate> {
    private final UpdateGlobalSecondaryIndexAction update;

    private final CreateGlobalSecondaryIndexAction create;

    private final DeleteGlobalSecondaryIndexAction delete;

    private GlobalSecondaryIndexUpdate(BuilderImpl builder) {
        this.update = builder.update;
        this.create = builder.create;
        this.delete = builder.delete;
    }

    /**
     * <p>
     * The name of an existing global secondary index, along with new provisioned throughput settings to be applied to
     * that index.
     * </p>
     * 
     * @return The name of an existing global secondary index, along with new provisioned throughput settings to be
     *         applied to that index.
     */
    public UpdateGlobalSecondaryIndexAction update() {
        return update;
    }

    /**
     * <p>
     * The parameters required for creating a global secondary index on an existing table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IndexName </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KeySchema </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AttributeDefinitions </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Projection </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProvisionedThroughput </code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The parameters required for creating a global secondary index on an existing table:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IndexName </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KeySchema </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AttributeDefinitions </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Projection </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ProvisionedThroughput </code>
     *         </p>
     *         </li>
     */
    public CreateGlobalSecondaryIndexAction create() {
        return create;
    }

    /**
     * <p>
     * The name of an existing global secondary index to be removed.
     * </p>
     * 
     * @return The name of an existing global secondary index to be removed.
     */
    public DeleteGlobalSecondaryIndexAction delete() {
        return delete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((update() == null) ? 0 : update().hashCode());
        hashCode = 31 * hashCode + ((create() == null) ? 0 : create().hashCode());
        hashCode = 31 * hashCode + ((delete() == null) ? 0 : delete().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalSecondaryIndexUpdate)) {
            return false;
        }
        GlobalSecondaryIndexUpdate other = (GlobalSecondaryIndexUpdate) obj;
        if (other.update() == null ^ this.update() == null) {
            return false;
        }
        if (other.update() != null && !other.update().equals(this.update())) {
            return false;
        }
        if (other.create() == null ^ this.create() == null) {
            return false;
        }
        if (other.create() != null && !other.create().equals(this.create())) {
            return false;
        }
        if (other.delete() == null ^ this.delete() == null) {
            return false;
        }
        if (other.delete() != null && !other.delete().equals(this.delete())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (update() != null) {
            sb.append("Update: ").append(update()).append(",");
        }
        if (create() != null) {
            sb.append("Create: ").append(create()).append(",");
        }
        if (delete() != null) {
            sb.append("Delete: ").append(delete()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GlobalSecondaryIndexUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, GlobalSecondaryIndexUpdate> {
        /**
         * <p>
         * The name of an existing global secondary index, along with new provisioned throughput settings to be applied
         * to that index.
         * </p>
         * 
         * @param update
         *        The name of an existing global secondary index, along with new provisioned throughput settings to be
         *        applied to that index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder update(UpdateGlobalSecondaryIndexAction update);

        /**
         * <p>
         * The parameters required for creating a global secondary index on an existing table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeySchema </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AttributeDefinitions </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput </code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param create
         *        The parameters required for creating a global secondary index on an existing table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeySchema </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AttributeDefinitions </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProvisionedThroughput </code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder create(CreateGlobalSecondaryIndexAction create);

        /**
         * <p>
         * The name of an existing global secondary index to be removed.
         * </p>
         * 
         * @param delete
         *        The name of an existing global secondary index to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delete(DeleteGlobalSecondaryIndexAction delete);
    }

    private static final class BuilderImpl implements Builder {
        private UpdateGlobalSecondaryIndexAction update;

        private CreateGlobalSecondaryIndexAction create;

        private DeleteGlobalSecondaryIndexAction delete;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalSecondaryIndexUpdate model) {
            setUpdate(model.update);
            setCreate(model.create);
            setDelete(model.delete);
        }

        public final UpdateGlobalSecondaryIndexAction getUpdate() {
            return update;
        }

        @Override
        public final Builder update(UpdateGlobalSecondaryIndexAction update) {
            this.update = update;
            return this;
        }

        public final void setUpdate(UpdateGlobalSecondaryIndexAction update) {
            this.update = update;
        }

        public final CreateGlobalSecondaryIndexAction getCreate() {
            return create;
        }

        @Override
        public final Builder create(CreateGlobalSecondaryIndexAction create) {
            this.create = create;
            return this;
        }

        public final void setCreate(CreateGlobalSecondaryIndexAction create) {
            this.create = create;
        }

        public final DeleteGlobalSecondaryIndexAction getDelete() {
            return delete;
        }

        @Override
        public final Builder delete(DeleteGlobalSecondaryIndexAction delete) {
            this.delete = delete;
            return this;
        }

        public final void setDelete(DeleteGlobalSecondaryIndexAction delete) {
            this.delete = delete;
        }

        @Override
        public GlobalSecondaryIndexUpdate build() {
            return new GlobalSecondaryIndexUpdate(this);
        }
    }
}
