/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsOfResourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListTagsOfResourceRequest.Builder, ListTagsOfResourceRequest> {
    private final String resourceArn;

    private final String nextToken;

    private ListTagsOfResourceRequest(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * An optional string that, if supplied, must be copied from the output of a previous call to ListTagOfResource.
     * When provided in this manner, this API fetches the next page of results.
     * </p>
     * 
     * @return An optional string that, if supplied, must be copied from the output of a previous call to
     *         ListTagOfResource. When provided in this manner, this API fetches the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceArn() == null) ? 0 : resourceArn().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsOfResourceRequest)) {
            return false;
        }
        ListTagsOfResourceRequest other = (ListTagsOfResourceRequest) obj;
        if (other.resourceArn() == null ^ this.resourceArn() == null) {
            return false;
        }
        if (other.resourceArn() != null && !other.resourceArn().equals(this.resourceArn())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceArn() != null) {
            sb.append("ResourceArn: ").append(resourceArn()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTagsOfResourceRequest> {
        /**
         * <p>
         * The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param resourceArn
         *        The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * An optional string that, if supplied, must be copied from the output of a previous call to ListTagOfResource.
         * When provided in this manner, this API fetches the next page of results.
         * </p>
         * 
         * @param nextToken
         *        An optional string that, if supplied, must be copied from the output of a previous call to
         *        ListTagOfResource. When provided in this manner, this API fetches the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsOfResourceRequest model) {
            setResourceArn(model.resourceArn);
            setNextToken(model.nextToken);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTagsOfResourceRequest build() {
            return new ListTagsOfResourceRequest(this);
        }
    }
}
