/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsOfResourceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListTagsOfResourceResponse.Builder, ListTagsOfResourceResponse> {
    private final List<Tag> tags;

    private final String nextToken;

    private ListTagsOfResourceResponse(BuilderImpl builder) {
        this.tags = builder.tags;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The tags currently associated with the Amazon DynamoDB resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags currently associated with the Amazon DynamoDB resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * If this value is returned, there are additional results to be displayed. To retrieve them, call
     * ListTagsOfResource again, with NextToken set to this value.
     * </p>
     * 
     * @return If this value is returned, there are additional results to be displayed. To retrieve them, call
     *         ListTagsOfResource again, with NextToken set to this value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsOfResourceResponse)) {
            return false;
        }
        ListTagsOfResourceResponse other = (ListTagsOfResourceResponse) obj;
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTagsOfResourceResponse> {
        /**
         * <p>
         * The tags currently associated with the Amazon DynamoDB resource.
         * </p>
         * 
         * @param tags
         *        The tags currently associated with the Amazon DynamoDB resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags currently associated with the Amazon DynamoDB resource.
         * </p>
         * 
         * @param tags
         *        The tags currently associated with the Amazon DynamoDB resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * If this value is returned, there are additional results to be displayed. To retrieve them, call
         * ListTagsOfResource again, with NextToken set to this value.
         * </p>
         * 
         * @param nextToken
         *        If this value is returned, there are additional results to be displayed. To retrieve them, call
         *        ListTagsOfResource again, with NextToken set to this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Tag> tags;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsOfResourceResponse model) {
            setTags(model.tags);
            setNextToken(model.nextToken);
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTagsOfResourceResponse build() {
            return new ListTagsOfResourceResponse(this);
        }
    }
}
