/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>Query</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class QueryResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<QueryResponse.Builder, QueryResponse> {
    private final List<Map<String, AttributeValue>> items;

    private final Integer count;

    private final Integer scannedCount;

    private final Map<String, AttributeValue> lastEvaluatedKey;

    private final ConsumedCapacity consumedCapacity;

    private QueryResponse(BuilderImpl builder) {
        this.items = builder.items;
        this.count = builder.count;
        this.scannedCount = builder.scannedCount;
        this.lastEvaluatedKey = builder.lastEvaluatedKey;
        this.consumedCapacity = builder.consumedCapacity;
    }

    /**
     * <p>
     * An array of item attributes that match the query criteria. Each element in this array consists of an attribute
     * name and the value for that attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of item attributes that match the query criteria. Each element in this array consists of an
     *         attribute name and the value for that attribute.
     */
    public List<Map<String, AttributeValue>> items() {
        return items;
    }

    /**
     * <p>
     * The number of items in the response.
     * </p>
     * <p>
     * If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the number of items returned
     * after the filter was applied, and <code>ScannedCount</code> is the number of matching items before the filter was
     * applied.
     * </p>
     * <p>
     * If you did not use a filter in the request, then <code>Count</code> and <code>ScannedCount</code> are the same.
     * </p>
     * 
     * @return The number of items in the response.</p>
     *         <p>
     *         If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the number of items
     *         returned after the filter was applied, and <code>ScannedCount</code> is the number of matching items
     *         before the filter was applied.
     *         </p>
     *         <p>
     *         If you did not use a filter in the request, then <code>Count</code> and <code>ScannedCount</code> are the
     *         same.
     */
    public Integer count() {
        return count;
    }

    /**
     * <p>
     * The number of items evaluated, before any <code>QueryFilter</code> is applied. A high <code>ScannedCount</code>
     * value with few, or no, <code>Count</code> results indicates an inefficient <code>Query</code> operation. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
     * ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If you did not use a filter in the request, then <code>ScannedCount</code> is the same as <code>Count</code>.
     * </p>
     * 
     * @return The number of items evaluated, before any <code>QueryFilter</code> is applied. A high
     *         <code>ScannedCount</code> value with few, or no, <code>Count</code> results indicates an inefficient
     *         <code>Query</code> operation. For more information, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
     *         ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
     *         <p>
     *         If you did not use a filter in the request, then <code>ScannedCount</code> is the same as
     *         <code>Count</code>.
     */
    public Integer scannedCount() {
        return scannedCount;
    }

    /**
     * <p>
     * The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to
     * start a new operation, excluding this value in the new request.
     * </p>
     * <p>
     * If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there is no
     * more data to be retrieved.
     * </p>
     * <p>
     * If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in the result
     * set. The only way to know when you have reached the end of the result set is when <code>LastEvaluatedKey</code>
     * is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The primary key of the item where the operation stopped, inclusive of the previous result set. Use this
     *         value to start a new operation, excluding this value in the new request.</p>
     *         <p>
     *         If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there
     *         is no more data to be retrieved.
     *         </p>
     *         <p>
     *         If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in
     *         the result set. The only way to know when you have reached the end of the result set is when
     *         <code>LastEvaluatedKey</code> is empty.
     */
    public Map<String, AttributeValue> lastEvaluatedKey() {
        return lastEvaluatedKey;
    }

    /**
     * <p>
     * The capacity units consumed by the <code>Query</code> operation. The data returned includes the total provisioned
     * throughput consumed, along with statistics for the table and any indexes involved in the operation.
     * <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified
     * For more information, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
     * >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The capacity units consumed by the <code>Query</code> operation. The data returned includes the total
     *         provisioned throughput consumed, along with statistics for the table and any indexes involved in the
     *         operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
     *         parameter was specified For more information, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
     *         >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public ConsumedCapacity consumedCapacity() {
        return consumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((items() == null) ? 0 : items().hashCode());
        hashCode = 31 * hashCode + ((count() == null) ? 0 : count().hashCode());
        hashCode = 31 * hashCode + ((scannedCount() == null) ? 0 : scannedCount().hashCode());
        hashCode = 31 * hashCode + ((lastEvaluatedKey() == null) ? 0 : lastEvaluatedKey().hashCode());
        hashCode = 31 * hashCode + ((consumedCapacity() == null) ? 0 : consumedCapacity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse) obj;
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        if (other.count() != null && !other.count().equals(this.count())) {
            return false;
        }
        if (other.scannedCount() == null ^ this.scannedCount() == null) {
            return false;
        }
        if (other.scannedCount() != null && !other.scannedCount().equals(this.scannedCount())) {
            return false;
        }
        if (other.lastEvaluatedKey() == null ^ this.lastEvaluatedKey() == null) {
            return false;
        }
        if (other.lastEvaluatedKey() != null && !other.lastEvaluatedKey().equals(this.lastEvaluatedKey())) {
            return false;
        }
        if (other.consumedCapacity() == null ^ this.consumedCapacity() == null) {
            return false;
        }
        if (other.consumedCapacity() != null && !other.consumedCapacity().equals(this.consumedCapacity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        if (count() != null) {
            sb.append("Count: ").append(count()).append(",");
        }
        if (scannedCount() != null) {
            sb.append("ScannedCount: ").append(scannedCount()).append(",");
        }
        if (lastEvaluatedKey() != null) {
            sb.append("LastEvaluatedKey: ").append(lastEvaluatedKey()).append(",");
        }
        if (consumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(consumedCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, QueryResponse> {
        /**
         * <p>
         * An array of item attributes that match the query criteria. Each element in this array consists of an
         * attribute name and the value for that attribute.
         * </p>
         * 
         * @param items
         *        An array of item attributes that match the query criteria. Each element in this array consists of an
         *        attribute name and the value for that attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<Map<String, AttributeValue>> items);

        /**
         * <p>
         * An array of item attributes that match the query criteria. Each element in this array consists of an
         * attribute name and the value for that attribute.
         * </p>
         * 
         * @param items
         *        An array of item attributes that match the query criteria. Each element in this array consists of an
         *        attribute name and the value for that attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Map<String, AttributeValue>... items);

        /**
         * <p>
         * The number of items in the response.
         * </p>
         * <p>
         * If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the number of items
         * returned after the filter was applied, and <code>ScannedCount</code> is the number of matching items before
         * the filter was applied.
         * </p>
         * <p>
         * If you did not use a filter in the request, then <code>Count</code> and <code>ScannedCount</code> are the
         * same.
         * </p>
         * 
         * @param count
         *        The number of items in the response.</p>
         *        <p>
         *        If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the number of items
         *        returned after the filter was applied, and <code>ScannedCount</code> is the number of matching items
         *        before the filter was applied.
         *        </p>
         *        <p>
         *        If you did not use a filter in the request, then <code>Count</code> and <code>ScannedCount</code> are
         *        the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The number of items evaluated, before any <code>QueryFilter</code> is applied. A high
         * <code>ScannedCount</code> value with few, or no, <code>Count</code> results indicates an inefficient
         * <code>Query</code> operation. For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
         * ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * If you did not use a filter in the request, then <code>ScannedCount</code> is the same as <code>Count</code>.
         * </p>
         * 
         * @param scannedCount
         *        The number of items evaluated, before any <code>QueryFilter</code> is applied. A high
         *        <code>ScannedCount</code> value with few, or no, <code>Count</code> results indicates an inefficient
         *        <code>Query</code> operation. For more information, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count
         *        and ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
         *        <p>
         *        If you did not use a filter in the request, then <code>ScannedCount</code> is the same as
         *        <code>Count</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scannedCount(Integer scannedCount);

        /**
         * <p>
         * The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value
         * to start a new operation, excluding this value in the new request.
         * </p>
         * <p>
         * If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there is no
         * more data to be retrieved.
         * </p>
         * <p>
         * If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in the
         * result set. The only way to know when you have reached the end of the result set is when
         * <code>LastEvaluatedKey</code> is empty.
         * </p>
         * 
         * @param lastEvaluatedKey
         *        The primary key of the item where the operation stopped, inclusive of the previous result set. Use
         *        this value to start a new operation, excluding this value in the new request.</p>
         *        <p>
         *        If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and
         *        there is no more data to be retrieved.
         *        </p>
         *        <p>
         *        If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in
         *        the result set. The only way to know when you have reached the end of the result set is when
         *        <code>LastEvaluatedKey</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey);

        /**
         * <p>
         * The capacity units consumed by the <code>Query</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         * >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the <code>Query</code> operation. The data returned includes the total
         *        provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         *        operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         *        parameter was specified For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         *        >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity consumedCapacity);
    }

    private static final class BuilderImpl implements Builder {
        private List<Map<String, AttributeValue>> items;

        private Integer count;

        private Integer scannedCount;

        private Map<String, AttributeValue> lastEvaluatedKey;

        private ConsumedCapacity consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResponse model) {
            setItems(model.items);
            setCount(model.count);
            setScannedCount(model.scannedCount);
            setLastEvaluatedKey(model.lastEvaluatedKey);
            setConsumedCapacity(model.consumedCapacity);
        }

        public final Collection<Map<String, AttributeValue>> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<Map<String, AttributeValue>> items) {
            this.items = ItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Map<String, AttributeValue>... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<Map<String, AttributeValue>> items) {
            this.items = ItemListCopier.copy(items);
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Integer getScannedCount() {
            return scannedCount;
        }

        @Override
        public final Builder scannedCount(Integer scannedCount) {
            this.scannedCount = scannedCount;
            return this;
        }

        public final void setScannedCount(Integer scannedCount) {
            this.scannedCount = scannedCount;
        }

        public final Map<String, AttributeValue> getLastEvaluatedKey() {
            return lastEvaluatedKey;
        }

        @Override
        public final Builder lastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copy(lastEvaluatedKey);
            return this;
        }

        public final void setLastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copy(lastEvaluatedKey);
        }

        public final ConsumedCapacity getConsumedCapacity() {
            return consumedCapacity;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
        }

        @Override
        public QueryResponse build() {
            return new QueryResponse(this);
        }
    }
}
