/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.RecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of a unique event within a stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Record implements StructuredPojo, ToCopyableBuilder<Record.Builder, Record> {
    private final String eventID;

    private final String eventName;

    private final String eventVersion;

    private final String eventSource;

    private final String awsRegion;

    private final StreamRecord dynamodb;

    private final Identity userIdentity;

    private Record(BuilderImpl builder) {
        this.eventID = builder.eventID;
        this.eventName = builder.eventName;
        this.eventVersion = builder.eventVersion;
        this.eventSource = builder.eventSource;
        this.awsRegion = builder.awsRegion;
        this.dynamodb = builder.dynamodb;
        this.userIdentity = builder.userIdentity;
    }

    /**
     * <p>
     * A globally unique identifier for the event that was recorded in this stream record.
     * </p>
     * 
     * @return A globally unique identifier for the event that was recorded in this stream record.
     */
    public String eventID() {
        return eventID;
    }

    /**
     * <p>
     * The type of data modification that was performed on the DynamoDB table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INSERT</code> - a new item was added to the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODIFY</code> - one or more of an existing item's attributes were modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVE</code> - the item was deleted from the table
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of data modification that was performed on the DynamoDB table:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INSERT</code> - a new item was added to the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODIFY</code> - one or more of an existing item's attributes were modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVE</code> - the item was deleted from the table
     *         </p>
     *         </li>
     * @see OperationType
     */
    public String eventName() {
        return eventName;
    }

    /**
     * <p>
     * The version number of the stream record format. This number is updated whenever the structure of
     * <code>Record</code> is modified.
     * </p>
     * <p>
     * Client applications must not assume that <code>eventVersion</code> will remain at a particular value, as this
     * number is subject to change at any time. In general, <code>eventVersion</code> will only increase as the
     * low-level DynamoDB Streams API evolves.
     * </p>
     * 
     * @return The version number of the stream record format. This number is updated whenever the structure of
     *         <code>Record</code> is modified.</p>
     *         <p>
     *         Client applications must not assume that <code>eventVersion</code> will remain at a particular value, as
     *         this number is subject to change at any time. In general, <code>eventVersion</code> will only increase as
     *         the low-level DynamoDB Streams API evolves.
     */
    public String eventVersion() {
        return eventVersion;
    }

    /**
     * <p>
     * The AWS service from which the stream record originated. For DynamoDB Streams, this is <code>aws:dynamodb</code>.
     * </p>
     * 
     * @return The AWS service from which the stream record originated. For DynamoDB Streams, this is
     *         <code>aws:dynamodb</code>.
     */
    public String eventSource() {
        return eventSource;
    }

    /**
     * <p>
     * The region in which the <code>GetRecords</code> request was received.
     * </p>
     * 
     * @return The region in which the <code>GetRecords</code> request was received.
     */
    public String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The main body of the stream record, containing all of the DynamoDB-specific fields.
     * </p>
     * 
     * @return The main body of the stream record, containing all of the DynamoDB-specific fields.
     */
    public StreamRecord dynamodb() {
        return dynamodb;
    }

    /**
     * <p>
     * Items that are deleted by the Time to Live process after expiration have the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Records[].userIdentity.type
     * </p>
     * <p>
     * "Service"
     * </p>
     * </li>
     * <li>
     * <p>
     * Records[].userIdentity.principalId
     * </p>
     * <p>
     * "dynamodb.amazonaws.com"
     * </p>
     * </li>
     * </ul>
     * 
     * @return Items that are deleted by the Time to Live process after expiration have the following fields: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Records[].userIdentity.type
     *         </p>
     *         <p>
     *         "Service"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Records[].userIdentity.principalId
     *         </p>
     *         <p>
     *         "dynamodb.amazonaws.com"
     *         </p>
     *         </li>
     */
    public Identity userIdentity() {
        return userIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((eventID() == null) ? 0 : eventID().hashCode());
        hashCode = 31 * hashCode + ((eventName() == null) ? 0 : eventName().hashCode());
        hashCode = 31 * hashCode + ((eventVersion() == null) ? 0 : eventVersion().hashCode());
        hashCode = 31 * hashCode + ((eventSource() == null) ? 0 : eventSource().hashCode());
        hashCode = 31 * hashCode + ((awsRegion() == null) ? 0 : awsRegion().hashCode());
        hashCode = 31 * hashCode + ((dynamodb() == null) ? 0 : dynamodb().hashCode());
        hashCode = 31 * hashCode + ((userIdentity() == null) ? 0 : userIdentity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record) obj;
        if (other.eventID() == null ^ this.eventID() == null) {
            return false;
        }
        if (other.eventID() != null && !other.eventID().equals(this.eventID())) {
            return false;
        }
        if (other.eventName() == null ^ this.eventName() == null) {
            return false;
        }
        if (other.eventName() != null && !other.eventName().equals(this.eventName())) {
            return false;
        }
        if (other.eventVersion() == null ^ this.eventVersion() == null) {
            return false;
        }
        if (other.eventVersion() != null && !other.eventVersion().equals(this.eventVersion())) {
            return false;
        }
        if (other.eventSource() == null ^ this.eventSource() == null) {
            return false;
        }
        if (other.eventSource() != null && !other.eventSource().equals(this.eventSource())) {
            return false;
        }
        if (other.awsRegion() == null ^ this.awsRegion() == null) {
            return false;
        }
        if (other.awsRegion() != null && !other.awsRegion().equals(this.awsRegion())) {
            return false;
        }
        if (other.dynamodb() == null ^ this.dynamodb() == null) {
            return false;
        }
        if (other.dynamodb() != null && !other.dynamodb().equals(this.dynamodb())) {
            return false;
        }
        if (other.userIdentity() == null ^ this.userIdentity() == null) {
            return false;
        }
        if (other.userIdentity() != null && !other.userIdentity().equals(this.userIdentity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (eventID() != null) {
            sb.append("EventID: ").append(eventID()).append(",");
        }
        if (eventName() != null) {
            sb.append("EventName: ").append(eventName()).append(",");
        }
        if (eventVersion() != null) {
            sb.append("EventVersion: ").append(eventVersion()).append(",");
        }
        if (eventSource() != null) {
            sb.append("EventSource: ").append(eventSource()).append(",");
        }
        if (awsRegion() != null) {
            sb.append("AwsRegion: ").append(awsRegion()).append(",");
        }
        if (dynamodb() != null) {
            sb.append("Dynamodb: ").append(dynamodb()).append(",");
        }
        if (userIdentity() != null) {
            sb.append("UserIdentity: ").append(userIdentity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Record> {
        /**
         * <p>
         * A globally unique identifier for the event that was recorded in this stream record.
         * </p>
         * 
         * @param eventID
         *        A globally unique identifier for the event that was recorded in this stream record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventID(String eventID);

        /**
         * <p>
         * The type of data modification that was performed on the DynamoDB table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INSERT</code> - a new item was added to the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFY</code> - one or more of an existing item's attributes were modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVE</code> - the item was deleted from the table
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventName
         *        The type of data modification that was performed on the DynamoDB table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INSERT</code> - a new item was added to the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFY</code> - one or more of an existing item's attributes were modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVE</code> - the item was deleted from the table
         *        </p>
         *        </li>
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder eventName(String eventName);

        /**
         * <p>
         * The type of data modification that was performed on the DynamoDB table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INSERT</code> - a new item was added to the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFY</code> - one or more of an existing item's attributes were modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVE</code> - the item was deleted from the table
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventName
         *        The type of data modification that was performed on the DynamoDB table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INSERT</code> - a new item was added to the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFY</code> - one or more of an existing item's attributes were modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVE</code> - the item was deleted from the table
         *        </p>
         *        </li>
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder eventName(OperationType eventName);

        /**
         * <p>
         * The version number of the stream record format. This number is updated whenever the structure of
         * <code>Record</code> is modified.
         * </p>
         * <p>
         * Client applications must not assume that <code>eventVersion</code> will remain at a particular value, as this
         * number is subject to change at any time. In general, <code>eventVersion</code> will only increase as the
         * low-level DynamoDB Streams API evolves.
         * </p>
         * 
         * @param eventVersion
         *        The version number of the stream record format. This number is updated whenever the structure of
         *        <code>Record</code> is modified.</p>
         *        <p>
         *        Client applications must not assume that <code>eventVersion</code> will remain at a particular value,
         *        as this number is subject to change at any time. In general, <code>eventVersion</code> will only
         *        increase as the low-level DynamoDB Streams API evolves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventVersion(String eventVersion);

        /**
         * <p>
         * The AWS service from which the stream record originated. For DynamoDB Streams, this is
         * <code>aws:dynamodb</code>.
         * </p>
         * 
         * @param eventSource
         *        The AWS service from which the stream record originated. For DynamoDB Streams, this is
         *        <code>aws:dynamodb</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSource(String eventSource);

        /**
         * <p>
         * The region in which the <code>GetRecords</code> request was received.
         * </p>
         * 
         * @param awsRegion
         *        The region in which the <code>GetRecords</code> request was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The main body of the stream record, containing all of the DynamoDB-specific fields.
         * </p>
         * 
         * @param dynamodb
         *        The main body of the stream record, containing all of the DynamoDB-specific fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamodb(StreamRecord dynamodb);

        /**
         * <p>
         * Items that are deleted by the Time to Live process after expiration have the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Records[].userIdentity.type
         * </p>
         * <p>
         * "Service"
         * </p>
         * </li>
         * <li>
         * <p>
         * Records[].userIdentity.principalId
         * </p>
         * <p>
         * "dynamodb.amazonaws.com"
         * </p>
         * </li>
         * </ul>
         * 
         * @param userIdentity
         *        Items that are deleted by the Time to Live process after expiration have the following fields: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Records[].userIdentity.type
         *        </p>
         *        <p>
         *        "Service"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Records[].userIdentity.principalId
         *        </p>
         *        <p>
         *        "dynamodb.amazonaws.com"
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdentity(Identity userIdentity);
    }

    private static final class BuilderImpl implements Builder {
        private String eventID;

        private String eventName;

        private String eventVersion;

        private String eventSource;

        private String awsRegion;

        private StreamRecord dynamodb;

        private Identity userIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            setEventID(model.eventID);
            setEventName(model.eventName);
            setEventVersion(model.eventVersion);
            setEventSource(model.eventSource);
            setAwsRegion(model.awsRegion);
            setDynamodb(model.dynamodb);
            setUserIdentity(model.userIdentity);
        }

        public final String getEventID() {
            return eventID;
        }

        @Override
        public final Builder eventID(String eventID) {
            this.eventID = eventID;
            return this;
        }

        public final void setEventID(String eventID) {
            this.eventID = eventID;
        }

        public final String getEventName() {
            return eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        @Override
        public final Builder eventName(OperationType eventName) {
            this.eventName(eventName.toString());
            return this;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public final String getEventVersion() {
            return eventVersion;
        }

        @Override
        public final Builder eventVersion(String eventVersion) {
            this.eventVersion = eventVersion;
            return this;
        }

        public final void setEventVersion(String eventVersion) {
            this.eventVersion = eventVersion;
        }

        public final String getEventSource() {
            return eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final StreamRecord getDynamodb() {
            return dynamodb;
        }

        @Override
        public final Builder dynamodb(StreamRecord dynamodb) {
            this.dynamodb = dynamodb;
            return this;
        }

        public final void setDynamodb(StreamRecord dynamodb) {
            this.dynamodb = dynamodb;
        }

        public final Identity getUserIdentity() {
            return userIdentity;
        }

        @Override
        public final Builder userIdentity(Identity userIdentity) {
            this.userIdentity = userIdentity;
            return this;
        }

        public final void setUserIdentity(Identity userIdentity) {
            this.userIdentity = userIdentity;
        }

        @Override
        public Record build() {
            return new Record(this);
        }
    }
}
