/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TagResourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<TagResourceRequest.Builder, TagResourceRequest> {
    private final String resourceArn;

    private final List<Tag> tags;

    private TagResourceRequest(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Identifies the Amazon DynamoDB resource to which tags should be added. This value is an Amazon Resource Name
     * (ARN).
     * </p>
     * 
     * @return Identifies the Amazon DynamoDB resource to which tags should be added. This value is an Amazon Resource
     *         Name (ARN).
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The tags to be assigned to the Amazon DynamoDB resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to be assigned to the Amazon DynamoDB resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceArn() == null) ? 0 : resourceArn().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourceRequest)) {
            return false;
        }
        TagResourceRequest other = (TagResourceRequest) obj;
        if (other.resourceArn() == null ^ this.resourceArn() == null) {
            return false;
        }
        if (other.resourceArn() != null && !other.resourceArn().equals(this.resourceArn())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceArn() != null) {
            sb.append("ResourceArn: ").append(resourceArn()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TagResourceRequest> {
        /**
         * <p>
         * Identifies the Amazon DynamoDB resource to which tags should be added. This value is an Amazon Resource Name
         * (ARN).
         * </p>
         * 
         * @param resourceArn
         *        Identifies the Amazon DynamoDB resource to which tags should be added. This value is an Amazon
         *        Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The tags to be assigned to the Amazon DynamoDB resource.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the Amazon DynamoDB resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be assigned to the Amazon DynamoDB resource.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the Amazon DynamoDB resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceArn;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(TagResourceRequest model) {
            setResourceArn(model.resourceArn);
            setTags(model.tags);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @Override
        public TagResourceRequest build() {
            return new TagResourceRequest(this);
        }
    }
}
