/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.Collection;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.ItemCollection;
import software.amazon.awssdk.services.dynamodb.document.KeyAttribute;
import software.amazon.awssdk.services.dynamodb.document.ScanFilter;
import software.amazon.awssdk.services.dynamodb.document.ScanOutcome;
import software.amazon.awssdk.services.dynamodb.document.Table;
import software.amazon.awssdk.services.dynamodb.document.api.ScanApi;
import software.amazon.awssdk.services.dynamodb.document.internal.AbstractImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.internal.ScanCollection;
import software.amazon.awssdk.services.dynamodb.document.spec.ScanSpec;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;

public class ScanImpl
extends AbstractImpl
implements ScanApi {
    public ScanImpl(DynamoDBClient client, Table table) {
        super(client, table);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanFilter ... scanFilters) {
        return this.doScan(new ScanSpec().withScanFilters(scanFilters));
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doScan(new ScanSpec().withFilterExpression(filterExpression).withNameMap(nameMap).valueMap(valueMap));
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doScan(new ScanSpec().withFilterExpression(filterExpression).withProjectionExpression(projectionExpression).withNameMap(nameMap).valueMap(valueMap));
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanSpec spec) {
        return this.doScan(spec);
    }

    protected ItemCollection<ScanOutcome> doScan(ScanSpec spec) {
        Collection<ScanFilter> filters;
        String tableName = this.getTable().getTableName();
        ScanRequest.Builder requestBuilder = ((ScanRequest)((Object)spec.getRequest())).toBuilder().tableName(tableName);
        Collection<KeyAttribute> startKey = spec.getExclusiveStartKey();
        if (startKey != null) {
            requestBuilder.exclusiveStartKey(InternalUtils.toAttributeValueMap(startKey));
        }
        if ((filters = spec.scanFilters()) != null) {
            requestBuilder.scanFilter(InternalUtils.toAttributeConditionMap(filters));
        }
        Map<String, AttributeValue> attrValMap = InternalUtils.fromSimpleMap(spec.valueMap());
        requestBuilder.expressionAttributeNames(spec.nameMap()).expressionAttributeValues(attrValMap);
        spec.setRequest((AmazonWebServiceRequest)requestBuilder.build());
        return new ScanCollection(this.getClient(), spec);
    }
}

