/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;

public class StreamSpecificationUnmarshaller
implements Unmarshaller<StreamSpecification, JsonUnmarshallerContext> {
    private static final StreamSpecificationUnmarshaller INSTANCE = new StreamSpecificationUnmarshaller();

    public StreamSpecification unmarshall(JsonUnmarshallerContext context) throws Exception {
        StreamSpecification.Builder streamSpecificationBuilder = StreamSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StreamEnabled", targetDepth)) {
                    context.nextToken();
                    streamSpecificationBuilder.streamEnabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("StreamViewType", targetDepth)) {
                    context.nextToken();
                    streamSpecificationBuilder.streamViewType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StreamSpecification)streamSpecificationBuilder.build();
    }

    public static StreamSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

