/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.Stream;

public class StreamUnmarshaller
implements Unmarshaller<Stream, JsonUnmarshallerContext> {
    private static final StreamUnmarshaller INSTANCE = new StreamUnmarshaller();

    public Stream unmarshall(JsonUnmarshallerContext context) throws Exception {
        Stream.Builder streamBuilder = Stream.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StreamArn", targetDepth)) {
                    context.nextToken();
                    streamBuilder.streamArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    streamBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StreamLabel", targetDepth)) {
                    context.nextToken();
                    streamBuilder.streamLabel((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Stream)streamBuilder.build();
    }

    public static StreamUnmarshaller getInstance() {
        return INSTANCE;
    }
}

