/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateTable</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTableRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateTableRequest.Builder, CreateTableRequest> {
    private final List<AttributeDefinition> attributeDefinitions;

    private final String tableName;

    private final List<KeySchemaElement> keySchema;

    private final List<LocalSecondaryIndex> localSecondaryIndexes;

    private final List<GlobalSecondaryIndex> globalSecondaryIndexes;

    private final ProvisionedThroughput provisionedThroughput;

    private final StreamSpecification streamSpecification;

    private CreateTableRequest(BuilderImpl builder) {
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.streamSpecification = builder.streamSpecification;
    }

    /**
     * <p>
     * An array of attributes that describe the key schema for the table and indexes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of attributes that describe the key schema for the table and indexes.
     */
    public List<AttributeDefinition> attributeDefinitions() {
        return attributeDefinitions;
    }

    /**
     * <p>
     * The name of the table to create.
     * </p>
     * 
     * @return The name of the table to create.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Specifies the attributes that make up the primary key for a table or an index. The attributes in
     * <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more information,
     * see <a href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Each <code>KeySchemaElement</code> in the array is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AttributeName</code> - The name of this key attribute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KeyType</code> - The role that the key attribute will assume:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HASH</code> - partition key
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RANGE</code> - sort key
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from
     * DynamoDB' usage of an internal hash function to evenly distribute data items across partitions, based on their
     * partition key values.
     * </p>
     * <p>
     * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the
     * way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key
     * value.
     * </p>
     * </note>
     * <p>
     * For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of
     * <code>HASH</code>.
     * </p>
     * <p>
     * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this order:
     * The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must have a
     * <code>KeyType</code> of <code>RANGE</code>.
     * </p>
     * <p>
     * For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
     * >Specifying the Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the attributes that make up the primary key for a table or an index. The attributes in
     *         <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in
     *         the <i>Amazon DynamoDB Developer Guide</i>.</p>
     *         <p>
     *         Each <code>KeySchemaElement</code> in the array is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AttributeName</code> - The name of this key attribute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KeyType</code> - The role that the key attribute will assume:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HASH</code> - partition key
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RANGE</code> - sort key
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
     *         derives from DynamoDB' usage of an internal hash function to evenly distribute data items across
     *         partitions, based on their partition key values.
     *         </p>
     *         <p>
     *         The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives
     *         from the way DynamoDB stores items with the same partition key physically close together, in sorted order
     *         by the sort key value.
     *         </p>
     *         </note>
     *         <p>
     *         For a simple primary key (partition key), you must provide exactly one element with a
     *         <code>KeyType</code> of <code>HASH</code>.
     *         </p>
     *         <p>
     *         For a composite primary key (partition key and sort key), you must provide exactly two elements, in this
     *         order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element
     *         must have a <code>KeyType</code> of <code>RANGE</code>.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
     *         >Specifying the Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public List<KeySchemaElement> keySchema() {
        return keySchema;
    }

    /**
     * <p>
     * One or more local secondary indexes (the maximum is five) to be created on the table. Each index is scoped to a
     * given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local
     * secondary index is unconstrained.
     * </p>
     * <p>
     * Each local secondary index in the array includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
     * </p>
     * <p/></li>
     * <li>
     * <p>
     * <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin with
     * the same partition key as the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These
     * are in addition to the primary key attributes and index key attributes, which are automatically projected. Each
     * attribute specification is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProjectionType</code> - One of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected
     * attributes are in <code>NonKeyAttributes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - All of the table attributes are projected into the index.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of
     * the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this
     * counts as two distinct attributes when determining the total.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more local secondary indexes (the maximum is five) to be created on the table. Each index is
     *         scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise,
     *         the size of a local secondary index is unconstrained.</p>
     *         <p>
     *         Each local secondary index in the array includes the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
     *         </p>
     *         <p/></li>
     *         <li>
     *         <p>
     *         <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must
     *         begin with the same partition key as the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
     *         These are in addition to the primary key attributes and index key attributes, which are automatically
     *         projected. Each attribute specification is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ProjectionType</code> - One of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
     *         projected attributes are in <code>NonKeyAttributes</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - All of the table attributes are projected into the index.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     *         secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across
     *         all of the secondary indexes, must not exceed 20. If you project the same attribute into two different
     *         indexes, this counts as two distinct attributes when determining the total.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public List<LocalSecondaryIndex> localSecondaryIndexes() {
        return localSecondaryIndexes;
    }

    /**
     * <p>
     * One or more global secondary indexes (the maximum is five) to be created on the table. Each global secondary
     * index in the array includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
     * </p>
     * <p/></li>
     * <li>
     * <p>
     * <code>KeySchema</code> - Specifies the key schema for the global secondary index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These
     * are in addition to the primary key attributes and index key attributes, which are automatically projected. Each
     * attribute specification is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProjectionType</code> - One of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected
     * attributes are in <code>NonKeyAttributes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - All of the table attributes are projected into the index.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of
     * the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this
     * counts as two distinct attributes when determining the total.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
     * consisting of read and write capacity units.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more global secondary indexes (the maximum is five) to be created on the table. Each global
     *         secondary index in the array includes the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
     *         </p>
     *         <p/></li>
     *         <li>
     *         <p>
     *         <code>KeySchema</code> - Specifies the key schema for the global secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
     *         These are in addition to the primary key attributes and index key attributes, which are automatically
     *         projected. Each attribute specification is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ProjectionType</code> - One of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
     *         projected attributes are in <code>NonKeyAttributes</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - All of the table attributes are projected into the index.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     *         secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across
     *         all of the secondary indexes, must not exceed 20. If you project the same attribute into two different
     *         indexes, this counts as two distinct attributes when determining the total.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
     *         consisting of read and write capacity units.
     *         </p>
     *         </li>
     */
    public List<GlobalSecondaryIndex> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    /**
     * <p>
     * Represents the provisioned throughput settings for a specified table or index. The settings can be modified using
     * the <code>UpdateTable</code> operation.
     * </p>
     * <p>
     * For current minimum and maximum provisioned throughput values, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the <i>Amazon
     * DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return Represents the provisioned throughput settings for a specified table or index. The settings can be
     *         modified using the <code>UpdateTable</code> operation.</p>
     *         <p>
     *         For current minimum and maximum provisioned throughput values, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
     *         <i>Amazon DynamoDB Developer Guide</i>.
     */
    public ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     * <p>
     * The settings for DynamoDB Streams on the table. These settings consist of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>StreamEnabled</code> - Indicates whether Streams is to be enabled (true) or disabled (false).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines what
     * information is written to the table's stream. Valid values for <code>StreamViewType</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The settings for DynamoDB Streams on the table. These settings consist of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>StreamEnabled</code> - Indicates whether Streams is to be enabled (true) or disabled (false).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code>
     *         determines what information is written to the table's stream. Valid values for
     *         <code>StreamViewType</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the
     *         stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the
     *         stream.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public StreamSpecification streamSpecification() {
        return streamSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attributeDefinitions() == null) ? 0 : attributeDefinitions().hashCode());
        hashCode = 31 * hashCode + ((tableName() == null) ? 0 : tableName().hashCode());
        hashCode = 31 * hashCode + ((keySchema() == null) ? 0 : keySchema().hashCode());
        hashCode = 31 * hashCode + ((localSecondaryIndexes() == null) ? 0 : localSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + ((globalSecondaryIndexes() == null) ? 0 : globalSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + ((provisionedThroughput() == null) ? 0 : provisionedThroughput().hashCode());
        hashCode = 31 * hashCode + ((streamSpecification() == null) ? 0 : streamSpecification().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest) obj;
        if (other.attributeDefinitions() == null ^ this.attributeDefinitions() == null) {
            return false;
        }
        if (other.attributeDefinitions() != null && !other.attributeDefinitions().equals(this.attributeDefinitions())) {
            return false;
        }
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.keySchema() == null ^ this.keySchema() == null) {
            return false;
        }
        if (other.keySchema() != null && !other.keySchema().equals(this.keySchema())) {
            return false;
        }
        if (other.localSecondaryIndexes() == null ^ this.localSecondaryIndexes() == null) {
            return false;
        }
        if (other.localSecondaryIndexes() != null && !other.localSecondaryIndexes().equals(this.localSecondaryIndexes())) {
            return false;
        }
        if (other.globalSecondaryIndexes() == null ^ this.globalSecondaryIndexes() == null) {
            return false;
        }
        if (other.globalSecondaryIndexes() != null && !other.globalSecondaryIndexes().equals(this.globalSecondaryIndexes())) {
            return false;
        }
        if (other.provisionedThroughput() == null ^ this.provisionedThroughput() == null) {
            return false;
        }
        if (other.provisionedThroughput() != null && !other.provisionedThroughput().equals(this.provisionedThroughput())) {
            return false;
        }
        if (other.streamSpecification() == null ^ this.streamSpecification() == null) {
            return false;
        }
        if (other.streamSpecification() != null && !other.streamSpecification().equals(this.streamSpecification())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attributeDefinitions() != null) {
            sb.append("AttributeDefinitions: ").append(attributeDefinitions()).append(",");
        }
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (keySchema() != null) {
            sb.append("KeySchema: ").append(keySchema()).append(",");
        }
        if (localSecondaryIndexes() != null) {
            sb.append("LocalSecondaryIndexes: ").append(localSecondaryIndexes()).append(",");
        }
        if (globalSecondaryIndexes() != null) {
            sb.append("GlobalSecondaryIndexes: ").append(globalSecondaryIndexes()).append(",");
        }
        if (provisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(provisionedThroughput()).append(",");
        }
        if (streamSpecification() != null) {
            sb.append("StreamSpecification: ").append(streamSpecification()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateTableRequest> {
        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions);

        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(AttributeDefinition... attributeDefinitions);

        /**
         * <p>
         * The name of the table to create.
         * </p>
         * 
         * @param tableName
         *        The name of the table to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Specifies the attributes that make up the primary key for a table or an index. The attributes in
         * <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * Each <code>KeySchemaElement</code> in the array is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of this key attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeyType</code> - The role that the key attribute will assume:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HASH</code> - partition key
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code> - sort key
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives
         * from DynamoDB' usage of an internal hash function to evenly distribute data items across partitions, based on
         * their partition key values.
         * </p>
         * <p>
         * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from
         * the way DynamoDB stores items with the same partition key physically close together, in sorted order by the
         * sort key value.
         * </p>
         * </note>
         * <p>
         * For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of
         * <code>HASH</code>.
         * </p>
         * <p>
         * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this
         * order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must
         * have a <code>KeyType</code> of <code>RANGE</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         * >Specifying the Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keySchema
         *        Specifies the attributes that make up the primary key for a table or an index. The attributes in
         *        <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a>
         *        in the <i>Amazon DynamoDB Developer Guide</i>.</p>
         *        <p>
         *        Each <code>KeySchemaElement</code> in the array is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AttributeName</code> - The name of this key attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeyType</code> - The role that the key attribute will assume:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HASH</code> - partition key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANGE</code> - sort key
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
         *        derives from DynamoDB' usage of an internal hash function to evenly distribute data items across
         *        partitions, based on their partition key values.
         *        </p>
         *        <p>
         *        The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute"
         *        derives from the way DynamoDB stores items with the same partition key physically close together, in
         *        sorted order by the sort key value.
         *        </p>
         *        </note>
         *        <p>
         *        For a simple primary key (partition key), you must provide exactly one element with a
         *        <code>KeyType</code> of <code>HASH</code>.
         *        </p>
         *        <p>
         *        For a composite primary key (partition key and sort key), you must provide exactly two elements, in
         *        this order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second
         *        element must have a <code>KeyType</code> of <code>RANGE</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         *        >Specifying the Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(Collection<KeySchemaElement> keySchema);

        /**
         * <p>
         * Specifies the attributes that make up the primary key for a table or an index. The attributes in
         * <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * Each <code>KeySchemaElement</code> in the array is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of this key attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeyType</code> - The role that the key attribute will assume:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HASH</code> - partition key
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code> - sort key
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives
         * from DynamoDB' usage of an internal hash function to evenly distribute data items across partitions, based on
         * their partition key values.
         * </p>
         * <p>
         * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from
         * the way DynamoDB stores items with the same partition key physically close together, in sorted order by the
         * sort key value.
         * </p>
         * </note>
         * <p>
         * For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of
         * <code>HASH</code>.
         * </p>
         * <p>
         * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this
         * order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must
         * have a <code>KeyType</code> of <code>RANGE</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         * >Specifying the Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keySchema
         *        Specifies the attributes that make up the primary key for a table or an index. The attributes in
         *        <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a>
         *        in the <i>Amazon DynamoDB Developer Guide</i>.</p>
         *        <p>
         *        Each <code>KeySchemaElement</code> in the array is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AttributeName</code> - The name of this key attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeyType</code> - The role that the key attribute will assume:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HASH</code> - partition key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANGE</code> - sort key
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
         *        derives from DynamoDB' usage of an internal hash function to evenly distribute data items across
         *        partitions, based on their partition key values.
         *        </p>
         *        <p>
         *        The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute"
         *        derives from the way DynamoDB stores items with the same partition key physically close together, in
         *        sorted order by the sort key value.
         *        </p>
         *        </note>
         *        <p>
         *        For a simple primary key (partition key), you must provide exactly one element with a
         *        <code>KeyType</code> of <code>HASH</code>.
         *        </p>
         *        <p>
         *        For a composite primary key (partition key and sort key), you must provide exactly two elements, in
         *        this order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second
         *        element must have a <code>KeyType</code> of <code>RANGE</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         *        >Specifying the Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(KeySchemaElement... keySchema);

        /**
         * <p>
         * One or more local secondary indexes (the maximum is five) to be created on the table. Each index is scoped to
         * a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a
         * local secondary index is unconstrained.
         * </p>
         * <p>
         * Each local secondary index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin
         * with the same partition key as the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes are in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param localSecondaryIndexes
         *        One or more local secondary indexes (the maximum is five) to be created on the table. Each index is
         *        scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise,
         *        the size of a local secondary index is unconstrained.</p>
         *        <p>
         *        Each local secondary index in the array includes the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must
         *        begin with the same partition key as the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes are in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 20. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes);

        /**
         * <p>
         * One or more local secondary indexes (the maximum is five) to be created on the table. Each index is scoped to
         * a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a
         * local secondary index is unconstrained.
         * </p>
         * <p>
         * Each local secondary index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin
         * with the same partition key as the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes are in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param localSecondaryIndexes
         *        One or more local secondary indexes (the maximum is five) to be created on the table. Each index is
         *        scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise,
         *        the size of a local secondary index is unconstrained.</p>
         *        <p>
         *        Each local secondary index in the array includes the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must
         *        begin with the same partition key as the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes are in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 20. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(LocalSecondaryIndex... localSecondaryIndexes);

        /**
         * <p>
         * One or more global secondary indexes (the maximum is five) to be created on the table. Each global secondary
         * index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes are in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
         * consisting of read and write capacity units.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalSecondaryIndexes
         *        One or more global secondary indexes (the maximum is five) to be created on the table. Each global
         *        secondary index in the array includes the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the global secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes are in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 20. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary
         *        index, consisting of read and write capacity units.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes);

        /**
         * <p>
         * One or more global secondary indexes (the maximum is five) to be created on the table. Each global secondary
         * index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes are in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
         * consisting of read and write capacity units.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalSecondaryIndexes
         *        One or more global secondary indexes (the maximum is five) to be created on the table. Each global
         *        secondary index in the array includes the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the global secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes are in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 20. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary
         *        index, consisting of read and write capacity units.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(GlobalSecondaryIndex... globalSecondaryIndexes);

        /**
         * <p>
         * Represents the provisioned throughput settings for a specified table or index. The settings can be modified
         * using the <code>UpdateTable</code> operation.
         * </p>
         * <p>
         * For current minimum and maximum provisioned throughput values, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param provisionedThroughput
         *        Represents the provisioned throughput settings for a specified table or index. The settings can be
         *        modified using the <code>UpdateTable</code> operation.</p>
         *        <p>
         *        For current minimum and maximum provisioned throughput values, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         *        <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         * <p>
         * The settings for DynamoDB Streams on the table. These settings consist of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>StreamEnabled</code> - Indicates whether Streams is to be enabled (true) or disabled (false).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines
         * what information is written to the table's stream. Valid values for <code>StreamViewType</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param streamSpecification
         *        The settings for DynamoDB Streams on the table. These settings consist of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>StreamEnabled</code> - Indicates whether Streams is to be enabled (true) or disabled (false).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code>
         *        determines what information is written to the table's stream. Valid values for
         *        <code>StreamViewType</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the
         *        stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the
         *        stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the
         *        stream.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSpecification(StreamSpecification streamSpecification);
    }

    private static final class BuilderImpl implements Builder {
        private List<AttributeDefinition> attributeDefinitions;

        private String tableName;

        private List<KeySchemaElement> keySchema;

        private List<LocalSecondaryIndex> localSecondaryIndexes;

        private List<GlobalSecondaryIndex> globalSecondaryIndexes;

        private ProvisionedThroughput provisionedThroughput;

        private StreamSpecification streamSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            setAttributeDefinitions(model.attributeDefinitions);
            setTableName(model.tableName);
            setKeySchema(model.keySchema);
            setLocalSecondaryIndexes(model.localSecondaryIndexes);
            setGlobalSecondaryIndexes(model.globalSecondaryIndexes);
            setProvisionedThroughput(model.provisionedThroughput);
            setStreamSpecification(model.streamSpecification);
        }

        public final Collection<AttributeDefinition> getAttributeDefinitions() {
            return attributeDefinitions;
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition... attributeDefinitions) {
            attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<KeySchemaElement> getKeySchema() {
            return keySchema;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement... keySchema) {
            keySchema(Arrays.asList(keySchema));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
        }

        public final Collection<LocalSecondaryIndex> getLocalSecondaryIndexes() {
            return localSecondaryIndexes;
        }

        @Override
        public final Builder localSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexListCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(LocalSecondaryIndex... localSecondaryIndexes) {
            localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        public final void setLocalSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexListCopier.copy(localSecondaryIndexes);
        }

        public final Collection<GlobalSecondaryIndex> getGlobalSecondaryIndexes() {
            return globalSecondaryIndexes;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndex... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
        }

        public final ProvisionedThroughput getProvisionedThroughput() {
            return provisionedThroughput;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
        }

        public final StreamSpecification getStreamSpecification() {
            return streamSpecification;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final void setStreamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
        }

        @Override
        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }
    }
}
