/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.DeleteGlobalSecondaryIndexActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a global secondary index to be deleted from an existing table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteGlobalSecondaryIndexAction implements StructuredPojo,
        ToCopyableBuilder<DeleteGlobalSecondaryIndexAction.Builder, DeleteGlobalSecondaryIndexAction> {
    private final String indexName;

    private DeleteGlobalSecondaryIndexAction(BuilderImpl builder) {
        this.indexName = builder.indexName;
    }

    /**
     * <p>
     * The name of the global secondary index to be deleted.
     * </p>
     * 
     * @return The name of the global secondary index to be deleted.
     */
    public String indexName() {
        return indexName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((indexName() == null) ? 0 : indexName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGlobalSecondaryIndexAction)) {
            return false;
        }
        DeleteGlobalSecondaryIndexAction other = (DeleteGlobalSecondaryIndexAction) obj;
        if (other.indexName() == null ^ this.indexName() == null) {
            return false;
        }
        if (other.indexName() != null && !other.indexName().equals(this.indexName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (indexName() != null) {
            sb.append("IndexName: ").append(indexName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeleteGlobalSecondaryIndexActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteGlobalSecondaryIndexAction> {
        /**
         * <p>
         * The name of the global secondary index to be deleted.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);
    }

    private static final class BuilderImpl implements Builder {
        private String indexName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGlobalSecondaryIndexAction model) {
            setIndexName(model.indexName);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public DeleteGlobalSecondaryIndexAction build() {
            return new DeleteGlobalSecondaryIndexAction(this);
        }
    }
}
