/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.DeleteRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to perform a <code>DeleteItem</code> operation on an item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteRequest implements StructuredPojo, ToCopyableBuilder<DeleteRequest.Builder, DeleteRequest> {
    private final Map<String, AttributeValue> key;

    private DeleteRequest(BuilderImpl builder) {
        this.key = builder.key;
    }

    /**
     * <p>
     * A map of attribute name to attribute values, representing the primary key of the item to delete. All of the
     * table's primary key attributes must be specified, and their data types must match those of the table's key
     * schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of attribute name to attribute values, representing the primary key of the item to delete. All of
     *         the table's primary key attributes must be specified, and their data types must match those of the
     *         table's key schema.
     */
    public Map<String, AttributeValue> key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRequest)) {
            return false;
        }
        DeleteRequest other = (DeleteRequest) obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeleteRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteRequest> {
        /**
         * <p>
         * A map of attribute name to attribute values, representing the primary key of the item to delete. All of the
         * table's primary key attributes must be specified, and their data types must match those of the table's key
         * schema.
         * </p>
         * 
         * @param key
         *        A map of attribute name to attribute values, representing the primary key of the item to delete. All
         *        of the table's primary key attributes must be specified, and their data types must match those of the
         *        table's key schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(Map<String, AttributeValue> key);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, AttributeValue> key;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRequest model) {
            setKey(model.key);
        }

        public final Map<String, AttributeValue> getKey() {
            return key;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
        }

        @Override
        public DeleteRequest build() {
            return new DeleteRequest(this);
        }
    }
}
