/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeTable</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTableResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeTableResponse.Builder, DescribeTableResponse> {
    private final TableDescription table;

    private DescribeTableResponse(BuilderImpl builder) {
        this.table = builder.table;
    }

    /**
     * <p>
     * The properties of the table.
     * </p>
     * 
     * @return The properties of the table.
     */
    public TableDescription table() {
        return table;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((table() == null) ? 0 : table().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableResponse)) {
            return false;
        }
        DescribeTableResponse other = (DescribeTableResponse) obj;
        if (other.table() == null ^ this.table() == null) {
            return false;
        }
        if (other.table() != null && !other.table().equals(this.table())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (table() != null) {
            sb.append("Table: ").append(table()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTableResponse> {
        /**
         * <p>
         * The properties of the table.
         * </p>
         * 
         * @param table
         *        The properties of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(TableDescription table);
    }

    private static final class BuilderImpl implements Builder {
        private TableDescription table;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableResponse model) {
            setTable(model.table);
        }

        public final TableDescription getTable() {
            return table;
        }

        @Override
        public final Builder table(TableDescription table) {
            this.table = table;
            return this;
        }

        public final void setTable(TableDescription table) {
            this.table = table;
        }

        @Override
        public DescribeTableResponse build() {
            return new DescribeTableResponse(this);
        }
    }
}
