/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>Query</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class QueryRequest extends AmazonWebServiceRequest implements ToCopyableBuilder<QueryRequest.Builder, QueryRequest> {
    private final String tableName;

    private final String indexName;

    private final String select;

    private final List<String> attributesToGet;

    private final Integer limit;

    private final Boolean consistentRead;

    private final Map<String, Condition> keyConditions;

    private final Map<String, Condition> queryFilter;

    private final String conditionalOperator;

    private final Boolean scanIndexForward;

    private final Map<String, AttributeValue> exclusiveStartKey;

    private final String returnConsumedCapacity;

    private final String projectionExpression;

    private final String filterExpression;

    private final String keyConditionExpression;

    private final Map<String, String> expressionAttributeNames;

    private final Map<String, AttributeValue> expressionAttributeValues;

    private QueryRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.select = builder.select;
        this.attributesToGet = builder.attributesToGet;
        this.limit = builder.limit;
        this.consistentRead = builder.consistentRead;
        this.keyConditions = builder.keyConditions;
        this.queryFilter = builder.queryFilter;
        this.conditionalOperator = builder.conditionalOperator;
        this.scanIndexForward = builder.scanIndexForward;
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.projectionExpression = builder.projectionExpression;
        this.filterExpression = builder.filterExpression;
        this.keyConditionExpression = builder.keyConditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    /**
     * <p>
     * The name of the table containing the requested items.
     * </p>
     * 
     * @return The name of the table containing the requested items.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name of an index to query. This index can be any local secondary index or global secondary index on the
     * table. Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName.</code>
     * </p>
     * 
     * @return The name of an index to query. This index can be any local secondary index or global secondary index on
     *         the table. Note that if you use the <code>IndexName</code> parameter, you must also provide
     *         <code>TableName.</code>
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the
     * count of matching items, or in the case of an index, some or all of the attributes projected into the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query
     * a local secondary index, then for each matching item in the index DynamoDB will fetch the entire item from the
     * parent table. If the index is configured to project all item attributes, then all of the data can be obtained
     * from the local secondary index, and no fetching is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have
     * been projected into the index. If the index is configured to project all attributes, this return value is
     * equivalent to specifying <code>ALL_ATTRIBUTES</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This
     * return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for
     * <code>Select</code>.
     * </p>
     * <p>
     * If you query or scan a local secondary index and request only attributes that are projected into that index, the
     * operation will read only the index and not the table. If any of the requested attributes are not projected into
     * the local secondary index, DynamoDB will fetch each of these attributes from the parent table. This extra
     * fetching incurs additional throughput cost and latency.
     * </p>
     * <p>
     * If you query or scan a global secondary index, you can only request attributes that are projected into the index.
     * Global secondary index queries cannot fetch attributes from the parent table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
     * <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an
     * index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request,
     * unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to
     * specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)
     * </p>
     * <note>
     * <p>
     * If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be
     * <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
     * </p>
     * </note>
     * 
     * @return The attributes to be returned in the result. You can retrieve all item attributes, specific item
     *         attributes, the count of matching items, or in the case of an index, some or all of the attributes
     *         projected into the index.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If
     *         you query a local secondary index, then for each matching item in the index DynamoDB will fetch the
     *         entire item from the parent table. If the index is configured to project all item attributes, then all of
     *         the data can be obtained from the local secondary index, and no fetching is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes
     *         that have been projected into the index. If the index is configured to project all attributes, this
     *         return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>.
     *         This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value
     *         for <code>Select</code>.
     *         </p>
     *         <p>
     *         If you query or scan a local secondary index and request only attributes that are projected into that
     *         index, the operation will read only the index and not the table. If any of the requested attributes are
     *         not projected into the local secondary index, DynamoDB will fetch each of these attributes from the
     *         parent table. This extra fetching incurs additional throughput cost and latency.
     *         </p>
     *         <p>
     *         If you query or scan a global secondary index, you can only request attributes that are projected into
     *         the index. Global secondary index queries cannot fetch attributes from the parent table.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
     *         <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when
     *         accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in
     *         a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
     *         usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>
     *         .)
     *         </p>
     *         <note>
     *         <p>
     *         If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can
     *         only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
     *         </p>
     * @see Select
     */
    public String select() {
        return select;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
     * >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
     *         >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public List<String> attributesToGet() {
        return attributesToGet;
    }

    /**
     * <p>
     * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the
     * number of items up to the limit while processing the results, it stops the operation and returns the matching
     * values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that
     * you can pick up where you left off. Also, if the processed data set size exceeds 1 MB before DynamoDB reaches
     * this limit, it stops the operation and returns the matching values up to the limit, and a key in
     * <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For more information,
     * see <a href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and
     * Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB
     *         processes the number of items up to the limit while processing the results, it stops the operation and
     *         returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a
     *         subsequent operation, so that you can pick up where you left off. Also, if the processed data set size
     *         exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values
     *         up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to
     *         continue the operation. For more information, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and
     *         Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly consistent
     * reads; otherwise, the operation uses eventually consistent reads.
     * </p>
     * <p>
     * Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary index
     * with <code>ConsistentRead</code> set to <code>true</code>, you will receive a <code>ValidationException</code>.
     * </p>
     * 
     * @return Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly
     *         consistent reads; otherwise, the operation uses eventually consistent reads.</p>
     *         <p>
     *         Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary
     *         index with <code>ConsistentRead</code> set to <code>true</code>, you will receive a
     *         <code>ValidationException</code>.
     */
    public Boolean consistentRead() {
        return consistentRead;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html"
     * >KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html"
     *         >KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, Condition> keyConditions() {
        return keyConditions;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html"
     * >QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html"
     *         >QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, Condition> queryFilter() {
        return queryFilter;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     *         >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @see ConditionalOperator
     */
    public String conditionalOperator() {
        return conditionalOperator;
    }

    /**
     * <p>
     * Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in ascending
     * order; if <code>false</code>, the traversal is performed in descending order.
     * </p>
     * <p>
     * Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is
     * Number, the results are stored in numeric order. For type String, the results are stored in order of ASCII
     * character code values. For type Binary, DynamoDB treats each byte of the binary data as unsigned.
     * </p>
     * <p>
     * If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which they
     * are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is
     * <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the results
     * to the client.
     * </p>
     * 
     * @return Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in
     *         ascending order; if <code>false</code>, the traversal is performed in descending order. </p>
     *         <p>
     *         Items with the same partition key value are stored in sorted order by sort key. If the sort key data type
     *         is Number, the results are stored in numeric order. For type String, the results are stored in order of
     *         ASCII character code values. For type Binary, DynamoDB treats each byte of the binary data as unsigned.
     *         </p>
     *         <p>
     *         If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which
     *         they are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is
     *         <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the
     *         results to the client.
     */
    public Boolean scanIndexForward() {
        return scanIndexForward;
    }

    /**
     * <p>
     * The primary key of the first item that this operation will evaluate. Use the value that was returned for
     * <code>LastEvaluatedKey</code> in the previous operation.
     * </p>
     * <p>
     * The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are allowed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The primary key of the first item that this operation will evaluate. Use the value that was returned for
     *         <code>LastEvaluatedKey</code> in the previous operation.</p>
     *         <p>
     *         The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are
     *         allowed.
     */
    public Map<String, AttributeValue> exclusiveStartKey() {
        return exclusiveStartKey;
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public String returnConsumedCapacity() {
        return returnConsumedCapacity;
    }

    /**
     * <p>
     * A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars,
     * sets, or elements of a JSON document. The attributes in the expression must be separated by commas.
     * </p>
     * <p>
     * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are
     * not found, they will not appear in the result.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return A string that identifies one or more attributes to retrieve from the table. These attributes can include
     *         scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by
     *         commas.</p>
     *         <p>
     *         If no attribute names are specified, then all attributes will be returned. If any of the requested
     *         attributes are not found, they will not appear in the result.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String projectionExpression() {
        return projectionExpression;
    }

    /**
     * <p>
     * A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but before the
     * data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not returned.
     * </p>
     * <p>
     * A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression based on a
     * partition key or a sort key.
     * </p>
     * <note>
     * <p>
     * A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering does
     * not consume any additional read capacity units.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
     * Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but
     *         before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria
     *         are not returned.</p>
     *         <p>
     *         A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression
     *         based on a partition key or a sort key.
     *         </p>
     *         <note>
     *         <p>
     *         A <code>FilterExpression</code> is applied after the items have already been read; the process of
     *         filtering does not consume any additional read capacity units.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults"
     *         >Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String filterExpression() {
        return filterExpression;
    }

    /**
     * <p>
     * The condition that specifies the key value(s) for items to be retrieved by the <code>Query</code> action.
     * </p>
     * <p>
     * The condition must perform an equality test on a single partition key value. The condition can also perform one
     * of several comparison tests on a single sort key value. <code>Query</code> can use
     * <code>KeyConditionExpression</code> to retrieve one item with a given partition key value and sort key value, or
     * several items that have the same partition key value but different sort key values.
     * </p>
     * <p>
     * The partition key equality test is required, and must be specified in the following format:
     * </p>
     * <p>
     * <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code>
     * </p>
     * <p>
     * If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with the
     * condition for the sort key. Following is an example, using the <b>=</b> comparison operator for the sort key:
     * </p>
     * <p>
     * <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code>
     * <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code>
     * </p>
     * <p>
     * Valid comparisons for the sort key condition are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal to
     * <code>:sortkeyval</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is less than
     * <code>:sortkeyval</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is less than or
     * equal to <code>:sortkeyval</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is greater than
     * <code>:sortkeyval</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is greater
     * than or equal to <code>:sortkeyval</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code>
     * <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to <code>:sortkeyval1</code>, and
     * less than or equal to <code>:sortkeyval2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if the sort
     * key value begins with a particular operand. (You cannot use this function with a sort key that is of type
     * Number.) Note that the function name <code>begins_with</code> is case-sensitive.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as <code>:partitionval</code> and
     * <code>:sortval</code> with actual values at runtime.
     * </p>
     * <p>
     * You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the partition
     * key and sort key with placeholder tokens. This option might be necessary if an attribute name conflicts with a
     * DynamoDB reserved word. For example, the following <code>KeyConditionExpression</code> parameter causes an error
     * because <i>Size</i> is a reserved word:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Size = :myval</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name <i>Size</i>.
     * <code>KeyConditionExpression</code> then is as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>#S = :myval</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a list of reserved words, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using
     * Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The condition that specifies the key value(s) for items to be retrieved by the <code>Query</code>
     *         action.</p>
     *         <p>
     *         The condition must perform an equality test on a single partition key value. The condition can also
     *         perform one of several comparison tests on a single sort key value. <code>Query</code> can use
     *         <code>KeyConditionExpression</code> to retrieve one item with a given partition key value and sort key
     *         value, or several items that have the same partition key value but different sort key values.
     *         </p>
     *         <p>
     *         The partition key equality test is required, and must be specified in the following format:
     *         </p>
     *         <p>
     *         <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code>
     *         </p>
     *         <p>
     *         If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with
     *         the condition for the sort key. Following is an example, using the <b>=</b> comparison operator for the
     *         sort key:
     *         </p>
     *         <p>
     *         <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code>
     *         <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code>
     *         </p>
     *         <p>
     *         Valid comparisons for the sort key condition are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal to
     *         <code>:sortkeyval</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is less
     *         than <code>:sortkeyval</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is less
     *         than or equal to <code>:sortkeyval</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is
     *         greater than <code>:sortkeyval</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is
     *         greater than or equal to <code>:sortkeyval</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code>
     *         <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to
     *         <code>:sortkeyval1</code>, and less than or equal to <code>:sortkeyval2</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if
     *         the sort key value begins with a particular operand. (You cannot use this function with a sort key that
     *         is of type Number.) Note that the function name <code>begins_with</code> is case-sensitive.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as
     *         <code>:partitionval</code> and <code>:sortval</code> with actual values at runtime.
     *         </p>
     *         <p>
     *         You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the
     *         partition key and sort key with placeholder tokens. This option might be necessary if an attribute name
     *         conflicts with a DynamoDB reserved word. For example, the following <code>KeyConditionExpression</code>
     *         parameter causes an error because <i>Size</i> is a reserved word:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Size = :myval</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name
     *         <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>#S = :myval</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For a list of reserved words, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
     *         Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     *         </p>
     *         <p>
     *         For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>,
     *         see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using
     *         Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String keyConditionExpression() {
        return keyConditionExpression;
    }

    /**
     * <p>
     * One or more substitution tokens for attribute names in an expression. The following are some use cases for using
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To access an attribute whose name conflicts with a DynamoDB reserved word.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a placeholder for repeating occurrences of an attribute name in an expression.
     * </p>
     * </li>
     * <li>
     * <p>
     * To prevent special characters in an attribute name from being misinterpreted in an expression.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following
     * attribute name:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Percentile</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For
     * the complete list of reserved words, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>{"#P":"Percentile"}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You could then use this substitution in an expression, as in this example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>#P = :val</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for
     * the actual value at runtime.
     * </p>
     * </note>
     * <p>
     * For more information on expression attribute names, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more substitution tokens for attribute names in an expression. The following are some use cases
     *         for using <code>ExpressionAttributeNames</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To access an attribute whose name conflicts with a DynamoDB reserved word.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a placeholder for repeating occurrences of an attribute name in an expression.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To prevent special characters in an attribute name from being misinterpreted in an expression.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
     *         following attribute name:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Percentile</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
     *         expression. (For the complete list of reserved words, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
     *         Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
     *         following for <code>ExpressionAttributeNames</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>{"#P":"Percentile"}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You could then use this substitution in an expression, as in this example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>#P = :val</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
     *         placeholders for the actual value at runtime.
     *         </p>
     *         </note>
     *         <p>
     *         For more information on expression attribute names, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, String> expressionAttributeNames() {
        return expressionAttributeNames;
    }

    /**
     * <p>
     * One or more values that can be substituted in an expression.
     * </p>
     * <p>
     * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that
     * you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following:
     * </p>
     * <p>
     * <code>Available | Backordered | Discontinued</code>
     * </p>
     * <p>
     * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     * </p>
     * <p>
     * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     * </p>
     * <p>
     * You could then use these values in an expression, such as this:
     * </p>
     * <p>
     * <code>ProductStatus IN (:avail, :back, :disc)</code>
     * </p>
     * <p>
     * For more information on expression attribute values, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more values that can be substituted in an expression.</p>
     *         <p>
     *         Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
     *         suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the
     *         following:
     *         </p>
     *         <p>
     *         <code>Available | Backordered | Discontinued</code>
     *         </p>
     *         <p>
     *         You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     *         </p>
     *         <p>
     *         <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     *         </p>
     *         <p>
     *         You could then use these values in an expression, such as this:
     *         </p>
     *         <p>
     *         <code>ProductStatus IN (:avail, :back, :disc)</code>
     *         </p>
     *         <p>
     *         For more information on expression attribute values, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     *         >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, AttributeValue> expressionAttributeValues() {
        return expressionAttributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tableName() == null) ? 0 : tableName().hashCode());
        hashCode = 31 * hashCode + ((indexName() == null) ? 0 : indexName().hashCode());
        hashCode = 31 * hashCode + ((select() == null) ? 0 : select().hashCode());
        hashCode = 31 * hashCode + ((attributesToGet() == null) ? 0 : attributesToGet().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((consistentRead() == null) ? 0 : consistentRead().hashCode());
        hashCode = 31 * hashCode + ((keyConditions() == null) ? 0 : keyConditions().hashCode());
        hashCode = 31 * hashCode + ((queryFilter() == null) ? 0 : queryFilter().hashCode());
        hashCode = 31 * hashCode + ((conditionalOperator() == null) ? 0 : conditionalOperator().hashCode());
        hashCode = 31 * hashCode + ((scanIndexForward() == null) ? 0 : scanIndexForward().hashCode());
        hashCode = 31 * hashCode + ((exclusiveStartKey() == null) ? 0 : exclusiveStartKey().hashCode());
        hashCode = 31 * hashCode + ((returnConsumedCapacity() == null) ? 0 : returnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + ((projectionExpression() == null) ? 0 : projectionExpression().hashCode());
        hashCode = 31 * hashCode + ((filterExpression() == null) ? 0 : filterExpression().hashCode());
        hashCode = 31 * hashCode + ((keyConditionExpression() == null) ? 0 : keyConditionExpression().hashCode());
        hashCode = 31 * hashCode + ((expressionAttributeNames() == null) ? 0 : expressionAttributeNames().hashCode());
        hashCode = 31 * hashCode + ((expressionAttributeValues() == null) ? 0 : expressionAttributeValues().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest) obj;
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.indexName() == null ^ this.indexName() == null) {
            return false;
        }
        if (other.indexName() != null && !other.indexName().equals(this.indexName())) {
            return false;
        }
        if (other.select() == null ^ this.select() == null) {
            return false;
        }
        if (other.select() != null && !other.select().equals(this.select())) {
            return false;
        }
        if (other.attributesToGet() == null ^ this.attributesToGet() == null) {
            return false;
        }
        if (other.attributesToGet() != null && !other.attributesToGet().equals(this.attributesToGet())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.consistentRead() == null ^ this.consistentRead() == null) {
            return false;
        }
        if (other.consistentRead() != null && !other.consistentRead().equals(this.consistentRead())) {
            return false;
        }
        if (other.keyConditions() == null ^ this.keyConditions() == null) {
            return false;
        }
        if (other.keyConditions() != null && !other.keyConditions().equals(this.keyConditions())) {
            return false;
        }
        if (other.queryFilter() == null ^ this.queryFilter() == null) {
            return false;
        }
        if (other.queryFilter() != null && !other.queryFilter().equals(this.queryFilter())) {
            return false;
        }
        if (other.conditionalOperator() == null ^ this.conditionalOperator() == null) {
            return false;
        }
        if (other.conditionalOperator() != null && !other.conditionalOperator().equals(this.conditionalOperator())) {
            return false;
        }
        if (other.scanIndexForward() == null ^ this.scanIndexForward() == null) {
            return false;
        }
        if (other.scanIndexForward() != null && !other.scanIndexForward().equals(this.scanIndexForward())) {
            return false;
        }
        if (other.exclusiveStartKey() == null ^ this.exclusiveStartKey() == null) {
            return false;
        }
        if (other.exclusiveStartKey() != null && !other.exclusiveStartKey().equals(this.exclusiveStartKey())) {
            return false;
        }
        if (other.returnConsumedCapacity() == null ^ this.returnConsumedCapacity() == null) {
            return false;
        }
        if (other.returnConsumedCapacity() != null && !other.returnConsumedCapacity().equals(this.returnConsumedCapacity())) {
            return false;
        }
        if (other.projectionExpression() == null ^ this.projectionExpression() == null) {
            return false;
        }
        if (other.projectionExpression() != null && !other.projectionExpression().equals(this.projectionExpression())) {
            return false;
        }
        if (other.filterExpression() == null ^ this.filterExpression() == null) {
            return false;
        }
        if (other.filterExpression() != null && !other.filterExpression().equals(this.filterExpression())) {
            return false;
        }
        if (other.keyConditionExpression() == null ^ this.keyConditionExpression() == null) {
            return false;
        }
        if (other.keyConditionExpression() != null && !other.keyConditionExpression().equals(this.keyConditionExpression())) {
            return false;
        }
        if (other.expressionAttributeNames() == null ^ this.expressionAttributeNames() == null) {
            return false;
        }
        if (other.expressionAttributeNames() != null && !other.expressionAttributeNames().equals(this.expressionAttributeNames())) {
            return false;
        }
        if (other.expressionAttributeValues() == null ^ this.expressionAttributeValues() == null) {
            return false;
        }
        if (other.expressionAttributeValues() != null
                && !other.expressionAttributeValues().equals(this.expressionAttributeValues())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (indexName() != null) {
            sb.append("IndexName: ").append(indexName()).append(",");
        }
        if (select() != null) {
            sb.append("Select: ").append(select()).append(",");
        }
        if (attributesToGet() != null) {
            sb.append("AttributesToGet: ").append(attributesToGet()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (consistentRead() != null) {
            sb.append("ConsistentRead: ").append(consistentRead()).append(",");
        }
        if (keyConditions() != null) {
            sb.append("KeyConditions: ").append(keyConditions()).append(",");
        }
        if (queryFilter() != null) {
            sb.append("QueryFilter: ").append(queryFilter()).append(",");
        }
        if (conditionalOperator() != null) {
            sb.append("ConditionalOperator: ").append(conditionalOperator()).append(",");
        }
        if (scanIndexForward() != null) {
            sb.append("ScanIndexForward: ").append(scanIndexForward()).append(",");
        }
        if (exclusiveStartKey() != null) {
            sb.append("ExclusiveStartKey: ").append(exclusiveStartKey()).append(",");
        }
        if (returnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(returnConsumedCapacity()).append(",");
        }
        if (projectionExpression() != null) {
            sb.append("ProjectionExpression: ").append(projectionExpression()).append(",");
        }
        if (filterExpression() != null) {
            sb.append("FilterExpression: ").append(filterExpression()).append(",");
        }
        if (keyConditionExpression() != null) {
            sb.append("KeyConditionExpression: ").append(keyConditionExpression()).append(",");
        }
        if (expressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(expressionAttributeNames()).append(",");
        }
        if (expressionAttributeValues() != null) {
            sb.append("ExpressionAttributeValues: ").append(expressionAttributeValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, QueryRequest> {
        /**
         * <p>
         * The name of the table containing the requested items.
         * </p>
         * 
         * @param tableName
         *        The name of the table containing the requested items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name of an index to query. This index can be any local secondary index or global secondary index on the
         * table. Note that if you use the <code>IndexName</code> parameter, you must also provide
         * <code>TableName.</code>
         * </p>
         * 
         * @param indexName
         *        The name of an index to query. This index can be any local secondary index or global secondary index
         *        on the table. Note that if you use the <code>IndexName</code> parameter, you must also provide
         *        <code>TableName.</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes,
         * the count of matching items, or in the case of an index, some or all of the attributes projected into the
         * index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you
         * query a local secondary index, then for each matching item in the index DynamoDB will fetch the entire item
         * from the parent table. If the index is configured to project all item attributes, then all of the data can be
         * obtained from the local secondary index, and no fetching is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that
         * have been projected into the index. If the index is configured to project all attributes, this return value
         * is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This
         * return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for
         * <code>Select</code>.
         * </p>
         * <p>
         * If you query or scan a local secondary index and request only attributes that are projected into that index,
         * the operation will read only the index and not the table. If any of the requested attributes are not
         * projected into the local secondary index, DynamoDB will fetch each of these attributes from the parent table.
         * This extra fetching incurs additional throughput cost and latency.
         * </p>
         * <p>
         * If you query or scan a global secondary index, you can only request attributes that are projected into the
         * index. Global secondary index queries cannot fetch attributes from the parent table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         * <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing
         * an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single
         * request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is
         * equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)
         * </p>
         * <note>
         * <p>
         * If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only
         * be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
         * </p>
         * </note>
         * 
         * @param select
         *        The attributes to be returned in the result. You can retrieve all item attributes, specific item
         *        attributes, the count of matching items, or in the case of an index, some or all of the attributes
         *        projected into the index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If
         *        you query a local secondary index, then for each matching item in the index DynamoDB will fetch the
         *        entire item from the parent table. If the index is configured to project all item attributes, then all
         *        of the data can be obtained from the local secondary index, and no fetching is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes
         *        that have been projected into the index. If the index is configured to project all attributes, this
         *        return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>.
         *        This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any
         *        value for <code>Select</code>.
         *        </p>
         *        <p>
         *        If you query or scan a local secondary index and request only attributes that are projected into that
         *        index, the operation will read only the index and not the table. If any of the requested attributes
         *        are not projected into the local secondary index, DynamoDB will fetch each of these attributes from
         *        the parent table. This extra fetching incurs additional throughput cost and latency.
         *        </p>
         *        <p>
         *        If you query or scan a global secondary index, you can only request attributes that are projected into
         *        the index. Global secondary index queries cannot fetch attributes from the parent table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         *        <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when
         *        accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together
         *        in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>.
         *        (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for
         *        <code>Select</code>.)
         *        </p>
         *        <note>
         *        <p>
         *        If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can
         *        only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an
         *        error.
         *        </p>
         * @see Select
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Select
         */
        Builder select(String select);

        /**
         * <p>
         * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes,
         * the count of matching items, or in the case of an index, some or all of the attributes projected into the
         * index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you
         * query a local secondary index, then for each matching item in the index DynamoDB will fetch the entire item
         * from the parent table. If the index is configured to project all item attributes, then all of the data can be
         * obtained from the local secondary index, and no fetching is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that
         * have been projected into the index. If the index is configured to project all attributes, this return value
         * is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This
         * return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for
         * <code>Select</code>.
         * </p>
         * <p>
         * If you query or scan a local secondary index and request only attributes that are projected into that index,
         * the operation will read only the index and not the table. If any of the requested attributes are not
         * projected into the local secondary index, DynamoDB will fetch each of these attributes from the parent table.
         * This extra fetching incurs additional throughput cost and latency.
         * </p>
         * <p>
         * If you query or scan a global secondary index, you can only request attributes that are projected into the
         * index. Global secondary index queries cannot fetch attributes from the parent table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         * <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing
         * an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single
         * request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is
         * equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)
         * </p>
         * <note>
         * <p>
         * If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only
         * be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
         * </p>
         * </note>
         * 
         * @param select
         *        The attributes to be returned in the result. You can retrieve all item attributes, specific item
         *        attributes, the count of matching items, or in the case of an index, some or all of the attributes
         *        projected into the index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If
         *        you query a local secondary index, then for each matching item in the index DynamoDB will fetch the
         *        entire item from the parent table. If the index is configured to project all item attributes, then all
         *        of the data can be obtained from the local secondary index, and no fetching is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes
         *        that have been projected into the index. If the index is configured to project all attributes, this
         *        return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>.
         *        This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any
         *        value for <code>Select</code>.
         *        </p>
         *        <p>
         *        If you query or scan a local secondary index and request only attributes that are projected into that
         *        index, the operation will read only the index and not the table. If any of the requested attributes
         *        are not projected into the local secondary index, DynamoDB will fetch each of these attributes from
         *        the parent table. This extra fetching incurs additional throughput cost and latency.
         *        </p>
         *        <p>
         *        If you query or scan a global secondary index, you can only request attributes that are projected into
         *        the index. Global secondary index queries cannot fetch attributes from the parent table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         *        <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when
         *        accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together
         *        in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>.
         *        (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for
         *        <code>Select</code>.)
         *        </p>
         *        <note>
         *        <p>
         *        If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can
         *        only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an
         *        error.
         *        </p>
         * @see Select
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Select
         */
        Builder select(Select select);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         * >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param attributesToGet
         *        This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see
         *        <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         *        >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(Collection<String> attributesToGet);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         * >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param attributesToGet
         *        This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see
         *        <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         *        >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(String... attributesToGet);

        /**
         * <p>
         * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes
         * the number of items up to the limit while processing the results, it stops the operation and returns the
         * matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
         * operation, so that you can pick up where you left off. Also, if the processed data set size exceeds 1 MB
         * before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit,
         * and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For
         * more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param limit
         *        The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB
         *        processes the number of items up to the limit while processing the results, it stops the operation and
         *        returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a
         *        subsequent operation, so that you can pick up where you left off. Also, if the processed data set size
         *        exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching
         *        values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation
         *        to continue the operation. For more information, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and
         *        Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly
         * consistent reads; otherwise, the operation uses eventually consistent reads.
         * </p>
         * <p>
         * Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary
         * index with <code>ConsistentRead</code> set to <code>true</code>, you will receive a
         * <code>ValidationException</code>.
         * </p>
         * 
         * @param consistentRead
         *        Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly
         *        consistent reads; otherwise, the operation uses eventually consistent reads.</p>
         *        <p>
         *        Strongly consistent reads are not supported on global secondary indexes. If you query a global
         *        secondary index with <code>ConsistentRead</code> set to <code>true</code>, you will receive a
         *        <code>ValidationException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consistentRead(Boolean consistentRead);

        /**
         * <p>
         * This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see <a
         * href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html"
         * >KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keyConditions
         *        This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see
         *        <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html"
         *        >KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyConditions(Map<String, Condition> keyConditions);

        /**
         * <p>
         * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html"
         * >QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param queryFilter
         *        This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html"
         *        >QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryFilter(Map<String, Condition> queryFilter);

        /**
         * <p>
         * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @see ConditionalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(String conditionalOperator);

        /**
         * <p>
         * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @see ConditionalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(ConditionalOperator conditionalOperator);

        /**
         * <p>
         * Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in
         * ascending order; if <code>false</code>, the traversal is performed in descending order.
         * </p>
         * <p>
         * Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is
         * Number, the results are stored in numeric order. For type String, the results are stored in order of ASCII
         * character code values. For type Binary, DynamoDB treats each byte of the binary data as unsigned.
         * </p>
         * <p>
         * If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which
         * they are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is
         * <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the
         * results to the client.
         * </p>
         * 
         * @param scanIndexForward
         *        Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in
         *        ascending order; if <code>false</code>, the traversal is performed in descending order. </p>
         *        <p>
         *        Items with the same partition key value are stored in sorted order by sort key. If the sort key data
         *        type is Number, the results are stored in numeric order. For type String, the results are stored in
         *        order of ASCII character code values. For type Binary, DynamoDB treats each byte of the binary data as
         *        unsigned.
         *        </p>
         *        <p>
         *        If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in
         *        which they are stored (by sort key value). This is the default behavior. If
         *        <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in reverse order by
         *        sort key value, and then returns the results to the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanIndexForward(Boolean scanIndexForward);

        /**
         * <p>
         * The primary key of the first item that this operation will evaluate. Use the value that was returned for
         * <code>LastEvaluatedKey</code> in the previous operation.
         * </p>
         * <p>
         * The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are
         * allowed.
         * </p>
         * 
         * @param exclusiveStartKey
         *        The primary key of the first item that this operation will evaluate. Use the value that was returned
         *        for <code>LastEvaluatedKey</code> in the previous operation.</p>
         *        <p>
         *        The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types
         *        are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        /**
         * <p>
         * A string that identifies one or more attributes to retrieve from the table. These attributes can include
         * scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.
         * </p>
         * <p>
         * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes
         * are not found, they will not appear in the result.
         * </p>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param projectionExpression
         *        A string that identifies one or more attributes to retrieve from the table. These attributes can
         *        include scalars, sets, or elements of a JSON document. The attributes in the expression must be
         *        separated by commas.</p>
         *        <p>
         *        If no attribute names are specified, then all attributes will be returned. If any of the requested
         *        attributes are not found, they will not appear in the result.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectionExpression(String projectionExpression);

        /**
         * <p>
         * A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but before
         * the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not
         * returned.
         * </p>
         * <p>
         * A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression based on
         * a partition key or a sort key.
         * </p>
         * <note>
         * <p>
         * A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering
         * does not consume any additional read capacity units.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults"
         * >Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param filterExpression
         *        A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but
         *        before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code>
         *        criteria are not returned.</p>
         *        <p>
         *        A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression
         *        based on a partition key or a sort key.
         *        </p>
         *        <note>
         *        <p>
         *        A <code>FilterExpression</code> is applied after the items have already been read; the process of
         *        filtering does not consume any additional read capacity units.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults"
         *        >Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpression(String filterExpression);

        /**
         * <p>
         * The condition that specifies the key value(s) for items to be retrieved by the <code>Query</code> action.
         * </p>
         * <p>
         * The condition must perform an equality test on a single partition key value. The condition can also perform
         * one of several comparison tests on a single sort key value. <code>Query</code> can use
         * <code>KeyConditionExpression</code> to retrieve one item with a given partition key value and sort key value,
         * or several items that have the same partition key value but different sort key values.
         * </p>
         * <p>
         * The partition key equality test is required, and must be specified in the following format:
         * </p>
         * <p>
         * <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code>
         * </p>
         * <p>
         * If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with the
         * condition for the sort key. Following is an example, using the <b>=</b> comparison operator for the sort key:
         * </p>
         * <p>
         * <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code>
         * <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code>
         * </p>
         * <p>
         * Valid comparisons for the sort key condition are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal to
         * <code>:sortkeyval</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is less than
         * <code>:sortkeyval</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is less
         * than or equal to <code>:sortkeyval</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is greater
         * than <code>:sortkeyval</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is greater
         * than or equal to <code>:sortkeyval</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code>
         * <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to <code>:sortkeyval1</code>,
         * and less than or equal to <code>:sortkeyval2</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if the
         * sort key value begins with a particular operand. (You cannot use this function with a sort key that is of
         * type Number.) Note that the function name <code>begins_with</code> is case-sensitive.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as <code>:partitionval</code>
         * and <code>:sortval</code> with actual values at runtime.
         * </p>
         * <p>
         * You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the
         * partition key and sort key with placeholder tokens. This option might be necessary if an attribute name
         * conflicts with a DynamoDB reserved word. For example, the following <code>KeyConditionExpression</code>
         * parameter causes an error because <i>Size</i> is a reserved word:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Size = :myval</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name
         * <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>#S = :myval</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For a list of reserved words, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>, see
         * <a href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using
         * Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keyConditionExpression
         *        The condition that specifies the key value(s) for items to be retrieved by the <code>Query</code>
         *        action.</p>
         *        <p>
         *        The condition must perform an equality test on a single partition key value. The condition can also
         *        perform one of several comparison tests on a single sort key value. <code>Query</code> can use
         *        <code>KeyConditionExpression</code> to retrieve one item with a given partition key value and sort key
         *        value, or several items that have the same partition key value but different sort key values.
         *        </p>
         *        <p>
         *        The partition key equality test is required, and must be specified in the following format:
         *        </p>
         *        <p>
         *        <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code>
         *        </p>
         *        <p>
         *        If you also want to provide a condition for the sort key, it must be combined using <code>AND</code>
         *        with the condition for the sort key. Following is an example, using the <b>=</b> comparison operator
         *        for the sort key:
         *        </p>
         *        <p>
         *        <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code>
         *        <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code>
         *        </p>
         *        <p>
         *        Valid comparisons for the sort key condition are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal
         *        to <code>:sortkeyval</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is
         *        less than <code>:sortkeyval</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is
         *        less than or equal to <code>:sortkeyval</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is
         *        greater than <code>:sortkeyval</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is
         *        greater than or equal to <code>:sortkeyval</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code>
         *        <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to
         *        <code>:sortkeyval1</code>, and less than or equal to <code>:sortkeyval2</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if
         *        the sort key value begins with a particular operand. (You cannot use this function with a sort key
         *        that is of type Number.) Note that the function name <code>begins_with</code> is case-sensitive.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as
         *        <code>:partitionval</code> and <code>:sortval</code> with actual values at runtime.
         *        </p>
         *        <p>
         *        You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the
         *        partition key and sort key with placeholder tokens. This option might be necessary if an attribute
         *        name conflicts with a DynamoDB reserved word. For example, the following
         *        <code>KeyConditionExpression</code> parameter causes an error because <i>Size</i> is a reserved word:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Size = :myval</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name
         *        <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>#S = :myval</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For a list of reserved words, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
         *        Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         *        </p>
         *        <p>
         *        For more information on <code>ExpressionAttributeNames</code> and
         *        <code>ExpressionAttributeValues</code>, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html"
         *        >Using Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyConditionExpression(String keyConditionExpression);

        /**
         * <p>
         * One or more substitution tokens for attribute names in an expression. The following are some use cases for
         * using <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To access an attribute whose name conflicts with a DynamoDB reserved word.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a placeholder for repeating occurrences of an attribute name in an expression.
         * </p>
         * </li>
         * <li>
         * <p>
         * To prevent special characters in an attribute name from being misinterpreted in an expression.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
         * following attribute name:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Percentile</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression.
         * (For the complete list of reserved words, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
         * <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>{"#P":"Percentile"}</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You could then use this substitution in an expression, as in this example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>#P = :val</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders
         * for the actual value at runtime.
         * </p>
         * </note>
         * <p>
         * For more information on expression attribute names, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeNames
         *        One or more substitution tokens for attribute names in an expression. The following are some use cases
         *        for using <code>ExpressionAttributeNames</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To access an attribute whose name conflicts with a DynamoDB reserved word.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a placeholder for repeating occurrences of an attribute name in an expression.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To prevent special characters in an attribute name from being misinterpreted in an expression.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider
         *        the following attribute name:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Percentile</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
         *        expression. (For the complete list of reserved words, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
         *        Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
         *        following for <code>ExpressionAttributeNames</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>{"#P":"Percentile"}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You could then use this substitution in an expression, as in this example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>#P = :val</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
         *        placeholders for the actual value at runtime.
         *        </p>
         *        </note>
         *        <p>
         *        For more information on expression attribute names, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeNames(Map<String, String> expressionAttributeNames);

        /**
         * <p>
         * One or more values that can be substituted in an expression.
         * </p>
         * <p>
         * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose
         * that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following:
         * </p>
         * <p>
         * <code>Available | Backordered | Discontinued</code>
         * </p>
         * <p>
         * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         * </p>
         * <p>
         * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         * </p>
         * <p>
         * You could then use these values in an expression, such as this:
         * </p>
         * <p>
         * <code>ProductStatus IN (:avail, :back, :disc)</code>
         * </p>
         * <p>
         * For more information on expression attribute values, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeValues
         *        One or more values that can be substituted in an expression.</p>
         *        <p>
         *        Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
         *        suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of
         *        the following:
         *        </p>
         *        <p>
         *        <code>Available | Backordered | Discontinued</code>
         *        </p>
         *        <p>
         *        You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         *        </p>
         *        <p>
         *        <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         *        </p>
         *        <p>
         *        You could then use these values in an expression, such as this:
         *        </p>
         *        <p>
         *        <code>ProductStatus IN (:avail, :back, :disc)</code>
         *        </p>
         *        <p>
         *        For more information on expression attribute values, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         *        >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues);
    }

    private static final class BuilderImpl implements Builder {
        private String tableName;

        private String indexName;

        private String select;

        private List<String> attributesToGet;

        private Integer limit;

        private Boolean consistentRead;

        private Map<String, Condition> keyConditions;

        private Map<String, Condition> queryFilter;

        private String conditionalOperator;

        private Boolean scanIndexForward;

        private Map<String, AttributeValue> exclusiveStartKey;

        private String returnConsumedCapacity;

        private String projectionExpression;

        private String filterExpression;

        private String keyConditionExpression;

        private Map<String, String> expressionAttributeNames;

        private Map<String, AttributeValue> expressionAttributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRequest model) {
            setTableName(model.tableName);
            setIndexName(model.indexName);
            setSelect(model.select);
            setAttributesToGet(model.attributesToGet);
            setLimit(model.limit);
            setConsistentRead(model.consistentRead);
            setKeyConditions(model.keyConditions);
            setQueryFilter(model.queryFilter);
            setConditionalOperator(model.conditionalOperator);
            setScanIndexForward(model.scanIndexForward);
            setExclusiveStartKey(model.exclusiveStartKey);
            setReturnConsumedCapacity(model.returnConsumedCapacity);
            setProjectionExpression(model.projectionExpression);
            setFilterExpression(model.filterExpression);
            setKeyConditionExpression(model.keyConditionExpression);
            setExpressionAttributeNames(model.expressionAttributeNames);
            setExpressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getSelect() {
            return select;
        }

        @Override
        public final Builder select(String select) {
            this.select = select;
            return this;
        }

        @Override
        public final Builder select(Select select) {
            this.select(select.toString());
            return this;
        }

        public final void setSelect(String select) {
            this.select = select;
        }

        public final Collection<String> getAttributesToGet() {
            return attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String... attributesToGet) {
            attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getConsistentRead() {
            return consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public final Map<String, Condition> getKeyConditions() {
            return keyConditions;
        }

        @Override
        public final Builder keyConditions(Map<String, Condition> keyConditions) {
            this.keyConditions = KeyConditionsCopier.copy(keyConditions);
            return this;
        }

        public final void setKeyConditions(Map<String, Condition> keyConditions) {
            this.keyConditions = KeyConditionsCopier.copy(keyConditions);
        }

        public final Map<String, Condition> getQueryFilter() {
            return queryFilter;
        }

        @Override
        public final Builder queryFilter(Map<String, Condition> queryFilter) {
            this.queryFilter = FilterConditionMapCopier.copy(queryFilter);
            return this;
        }

        public final void setQueryFilter(Map<String, Condition> queryFilter) {
            this.queryFilter = FilterConditionMapCopier.copy(queryFilter);
        }

        public final String getConditionalOperator() {
            return conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final Boolean getScanIndexForward() {
            return scanIndexForward;
        }

        @Override
        public final Builder scanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
            return this;
        }

        public final void setScanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
        }

        public final Map<String, AttributeValue> getExclusiveStartKey() {
            return exclusiveStartKey;
        }

        @Override
        public final Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copy(exclusiveStartKey);
            return this;
        }

        public final void setExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copy(exclusiveStartKey);
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getProjectionExpression() {
            return projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final String getFilterExpression() {
            return filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final String getKeyConditionExpression() {
            return keyConditionExpression;
        }

        @Override
        public final Builder keyConditionExpression(String keyConditionExpression) {
            this.keyConditionExpression = keyConditionExpression;
            return this;
        }

        public final void setKeyConditionExpression(String keyConditionExpression) {
            this.keyConditionExpression = keyConditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue> getExpressionAttributeValues() {
            return expressionAttributeValues;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this);
        }
    }
}
