/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.StandardMemberCopier;

@Generated("software.amazon.awssdk:codegen")
final class SecondaryIndexesCapacityMapCopier {
    static Map<String, Capacity> copy(Map<String, Capacity> secondaryIndexesCapacityMapParam) {
        if (secondaryIndexesCapacityMapParam == null) {
            return null;
        }
        Map<String, Capacity> secondaryIndexesCapacityMapParamCopy = new HashMap<>(secondaryIndexesCapacityMapParam.size());
        for (Map.Entry<String, Capacity> e : secondaryIndexesCapacityMapParam.entrySet()) {
            secondaryIndexesCapacityMapParamCopy.put(StandardMemberCopier.copy(e.getKey()), e.getValue());
        }
        return Collections.unmodifiableMap(secondaryIndexesCapacityMapParamCopy);
    }
}
