/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an <code>UpdateTable</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateTableRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateTableRequest.Builder, UpdateTableRequest> {
    private final List<AttributeDefinition> attributeDefinitions;

    private final String tableName;

    private final ProvisionedThroughput provisionedThroughput;

    private final List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;

    private final StreamSpecification streamSpecification;

    private UpdateTableRequest(BuilderImpl builder) {
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.globalSecondaryIndexUpdates = builder.globalSecondaryIndexUpdates;
        this.streamSpecification = builder.streamSpecification;
    }

    /**
     * <p>
     * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global
     * secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of attributes that describe the key schema for the table and indexes. If you are adding a new
     *         global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of
     *         the new index.
     */
    public List<AttributeDefinition> attributeDefinitions() {
        return attributeDefinitions;
    }

    /**
     * <p>
     * The name of the table to be updated.
     * </p>
     * 
     * @return The name of the table to be updated.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The new provisioned throughput settings for the specified table or index.
     * </p>
     * 
     * @return The new provisioned throughput settings for the specified table or index.
     */
    public ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     * <p>
     * An array of one or more global secondary indexes for the table. For each index in the array, you can request one
     * action:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Create</code> - add a new global secondary index to the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Delete</code> - remove a global secondary index from the table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
     * Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of one or more global secondary indexes for the table. For each index in the array, you can
     *         request one action:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Create</code> - add a new global secondary index to the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Delete</code> - remove a global secondary index from the table.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
     *         Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates() {
        return globalSecondaryIndexUpdates;
    }

    /**
     * <p>
     * Represents the DynamoDB Streams configuration for the table.
     * </p>
     * <note>
     * <p>
     * You will receive a <code>ResourceInUseException</code> if you attempt to enable a stream on a table that already
     * has a stream, or if you attempt to disable a stream on a table which does not have a stream.
     * </p>
     * </note>
     * 
     * @return Represents the DynamoDB Streams configuration for the table.</p> <note>
     *         <p>
     *         You will receive a <code>ResourceInUseException</code> if you attempt to enable a stream on a table that
     *         already has a stream, or if you attempt to disable a stream on a table which does not have a stream.
     *         </p>
     */
    public StreamSpecification streamSpecification() {
        return streamSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attributeDefinitions() == null) ? 0 : attributeDefinitions().hashCode());
        hashCode = 31 * hashCode + ((tableName() == null) ? 0 : tableName().hashCode());
        hashCode = 31 * hashCode + ((provisionedThroughput() == null) ? 0 : provisionedThroughput().hashCode());
        hashCode = 31 * hashCode + ((globalSecondaryIndexUpdates() == null) ? 0 : globalSecondaryIndexUpdates().hashCode());
        hashCode = 31 * hashCode + ((streamSpecification() == null) ? 0 : streamSpecification().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest) obj;
        if (other.attributeDefinitions() == null ^ this.attributeDefinitions() == null) {
            return false;
        }
        if (other.attributeDefinitions() != null && !other.attributeDefinitions().equals(this.attributeDefinitions())) {
            return false;
        }
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.provisionedThroughput() == null ^ this.provisionedThroughput() == null) {
            return false;
        }
        if (other.provisionedThroughput() != null && !other.provisionedThroughput().equals(this.provisionedThroughput())) {
            return false;
        }
        if (other.globalSecondaryIndexUpdates() == null ^ this.globalSecondaryIndexUpdates() == null) {
            return false;
        }
        if (other.globalSecondaryIndexUpdates() != null
                && !other.globalSecondaryIndexUpdates().equals(this.globalSecondaryIndexUpdates())) {
            return false;
        }
        if (other.streamSpecification() == null ^ this.streamSpecification() == null) {
            return false;
        }
        if (other.streamSpecification() != null && !other.streamSpecification().equals(this.streamSpecification())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attributeDefinitions() != null) {
            sb.append("AttributeDefinitions: ").append(attributeDefinitions()).append(",");
        }
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (provisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(provisionedThroughput()).append(",");
        }
        if (globalSecondaryIndexUpdates() != null) {
            sb.append("GlobalSecondaryIndexUpdates: ").append(globalSecondaryIndexUpdates()).append(",");
        }
        if (streamSpecification() != null) {
            sb.append("StreamSpecification: ").append(streamSpecification()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateTableRequest> {
        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global
         * secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new
         * index.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes. If you are adding a new
         *        global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s)
         *        of the new index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions);

        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global
         * secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new
         * index.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes. If you are adding a new
         *        global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s)
         *        of the new index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(AttributeDefinition... attributeDefinitions);

        /**
         * <p>
         * The name of the table to be updated.
         * </p>
         * 
         * @param tableName
         *        The name of the table to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The new provisioned throughput settings for the specified table or index.
         * </p>
         * 
         * @param provisionedThroughput
         *        The new provisioned throughput settings for the specified table or index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         * <p>
         * An array of one or more global secondary indexes for the table. For each index in the array, you can request
         * one action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Create</code> - add a new global secondary index to the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Delete</code> - remove a global secondary index from the table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
         * Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param globalSecondaryIndexUpdates
         *        An array of one or more global secondary indexes for the table. For each index in the array, you can
         *        request one action:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Create</code> - add a new global secondary index to the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Update</code> - modify the provisioned throughput settings of an existing global secondary
         *        index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Delete</code> - remove a global secondary index from the table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing
         *        Global Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates);

        /**
         * <p>
         * An array of one or more global secondary indexes for the table. For each index in the array, you can request
         * one action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Create</code> - add a new global secondary index to the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Delete</code> - remove a global secondary index from the table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
         * Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param globalSecondaryIndexUpdates
         *        An array of one or more global secondary indexes for the table. For each index in the array, you can
         *        request one action:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Create</code> - add a new global secondary index to the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Update</code> - modify the provisioned throughput settings of an existing global secondary
         *        index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Delete</code> - remove a global secondary index from the table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing
         *        Global Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate... globalSecondaryIndexUpdates);

        /**
         * <p>
         * Represents the DynamoDB Streams configuration for the table.
         * </p>
         * <note>
         * <p>
         * You will receive a <code>ResourceInUseException</code> if you attempt to enable a stream on a table that
         * already has a stream, or if you attempt to disable a stream on a table which does not have a stream.
         * </p>
         * </note>
         * 
         * @param streamSpecification
         *        Represents the DynamoDB Streams configuration for the table.</p> <note>
         *        <p>
         *        You will receive a <code>ResourceInUseException</code> if you attempt to enable a stream on a table
         *        that already has a stream, or if you attempt to disable a stream on a table which does not have a
         *        stream.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSpecification(StreamSpecification streamSpecification);
    }

    private static final class BuilderImpl implements Builder {
        private List<AttributeDefinition> attributeDefinitions;

        private String tableName;

        private ProvisionedThroughput provisionedThroughput;

        private List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;

        private StreamSpecification streamSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            setAttributeDefinitions(model.attributeDefinitions);
            setTableName(model.tableName);
            setProvisionedThroughput(model.provisionedThroughput);
            setGlobalSecondaryIndexUpdates(model.globalSecondaryIndexUpdates);
            setStreamSpecification(model.streamSpecification);
        }

        public final Collection<AttributeDefinition> getAttributeDefinitions() {
            return attributeDefinitions;
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition... attributeDefinitions) {
            attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final ProvisionedThroughput getProvisionedThroughput() {
            return provisionedThroughput;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
        }

        public final Collection<GlobalSecondaryIndexUpdate> getGlobalSecondaryIndexUpdates() {
            return globalSecondaryIndexUpdates;
        }

        @Override
        public final Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copy(globalSecondaryIndexUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate... globalSecondaryIndexUpdates) {
            globalSecondaryIndexUpdates(Arrays.asList(globalSecondaryIndexUpdates));
            return this;
        }

        public final void setGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copy(globalSecondaryIndexUpdates);
        }

        public final StreamSpecification getStreamSpecification() {
            return streamSpecification;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final void setStreamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
        }

        @Override
        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }
    }
}
