/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.BatchGetResponseMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacityMultipleCopier;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetItemResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetItemResponse> {
    private final Map<String, List<Map<String, AttributeValue>>> responses;
    private final Map<String, KeysAndAttributes> unprocessedKeys;
    private final List<ConsumedCapacity> consumedCapacity;

    private BatchGetItemResponse(BuilderImpl builder) {
        this.responses = builder.responses;
        this.unprocessedKeys = builder.unprocessedKeys;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public Map<String, List<Map<String, AttributeValue>>> responses() {
        return this.responses;
    }

    public Map<String, KeysAndAttributes> unprocessedKeys() {
        return this.unprocessedKeys;
    }

    public List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.responses() == null ? 0 : this.responses().hashCode());
        hashCode = 31 * hashCode + (this.unprocessedKeys() == null ? 0 : this.unprocessedKeys().hashCode());
        hashCode = 31 * hashCode + (this.consumedCapacity() == null ? 0 : this.consumedCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemResponse)) {
            return false;
        }
        BatchGetItemResponse other = (BatchGetItemResponse)((Object)obj);
        if (other.responses() == null ^ this.responses() == null) {
            return false;
        }
        if (other.responses() != null && !other.responses().equals(this.responses())) {
            return false;
        }
        if (other.unprocessedKeys() == null ^ this.unprocessedKeys() == null) {
            return false;
        }
        if (other.unprocessedKeys() != null && !other.unprocessedKeys().equals(this.unprocessedKeys())) {
            return false;
        }
        if (other.consumedCapacity() == null ^ this.consumedCapacity() == null) {
            return false;
        }
        return other.consumedCapacity() == null || other.consumedCapacity().equals(this.consumedCapacity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.responses() != null) {
            sb.append("Responses: ").append(this.responses()).append(",");
        }
        if (this.unprocessedKeys() != null) {
            sb.append("UnprocessedKeys: ").append(this.unprocessedKeys()).append(",");
        }
        if (this.consumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(this.consumedCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, List<Map<String, AttributeValue>>> responses;
        private Map<String, KeysAndAttributes> unprocessedKeys;
        private List<ConsumedCapacity> consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetItemResponse model) {
            this.setResponses(model.responses);
            this.setUnprocessedKeys(model.unprocessedKeys);
            this.setConsumedCapacity(model.consumedCapacity);
        }

        public final Map<String, ? extends Collection<Map<String, AttributeValue>>> getResponses() {
            return this.responses;
        }

        @Override
        public final Builder responses(Map<String, ? extends Collection<Map<String, AttributeValue>>> responses) {
            this.responses = BatchGetResponseMapCopier.copy(responses);
            return this;
        }

        public final void setResponses(Map<String, ? extends Collection<Map<String, AttributeValue>>> responses) {
            this.responses = BatchGetResponseMapCopier.copy(responses);
        }

        public final Map<String, KeysAndAttributes> getUnprocessedKeys() {
            return this.unprocessedKeys;
        }

        @Override
        public final Builder unprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
            this.unprocessedKeys = BatchGetRequestMapCopier.copy(unprocessedKeys);
            return this;
        }

        public final void setUnprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
            this.unprocessedKeys = BatchGetRequestMapCopier.copy(unprocessedKeys);
        }

        public final Collection<ConsumedCapacity> getConsumedCapacity() {
            return this.consumedCapacity;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity ... consumedCapacity) {
            this.consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
        }

        public BatchGetItemResponse build() {
            return new BatchGetItemResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetItemResponse> {
        public Builder responses(Map<String, ? extends Collection<Map<String, AttributeValue>>> var1);

        public Builder unprocessedKeys(Map<String, KeysAndAttributes> var1);

        public Builder consumedCapacity(Collection<ConsumedCapacity> var1);

        public Builder consumedCapacity(ConsumedCapacity ... var1);
    }
}

