/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.transform.WriteRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WriteRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, WriteRequest> {
    private final PutRequest putRequest;
    private final DeleteRequest deleteRequest;

    private WriteRequest(BuilderImpl builder) {
        this.putRequest = builder.putRequest;
        this.deleteRequest = builder.deleteRequest;
    }

    public PutRequest putRequest() {
        return this.putRequest;
    }

    public DeleteRequest deleteRequest() {
        return this.deleteRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.putRequest() == null ? 0 : this.putRequest().hashCode());
        hashCode = 31 * hashCode + (this.deleteRequest() == null ? 0 : this.deleteRequest().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteRequest)) {
            return false;
        }
        WriteRequest other = (WriteRequest)obj;
        if (other.putRequest() == null ^ this.putRequest() == null) {
            return false;
        }
        if (other.putRequest() != null && !other.putRequest().equals(this.putRequest())) {
            return false;
        }
        if (other.deleteRequest() == null ^ this.deleteRequest() == null) {
            return false;
        }
        return other.deleteRequest() == null || other.deleteRequest().equals(this.deleteRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.putRequest() != null) {
            sb.append("PutRequest: ").append(this.putRequest()).append(",");
        }
        if (this.deleteRequest() != null) {
            sb.append("DeleteRequest: ").append(this.deleteRequest()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private PutRequest putRequest;
        private DeleteRequest deleteRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteRequest model) {
            this.setPutRequest(model.putRequest);
            this.setDeleteRequest(model.deleteRequest);
        }

        public final PutRequest getPutRequest() {
            return this.putRequest;
        }

        @Override
        public final Builder putRequest(PutRequest putRequest) {
            this.putRequest = putRequest;
            return this;
        }

        public final void setPutRequest(PutRequest putRequest) {
            this.putRequest = putRequest;
        }

        public final DeleteRequest getDeleteRequest() {
            return this.deleteRequest;
        }

        @Override
        public final Builder deleteRequest(DeleteRequest deleteRequest) {
            this.deleteRequest = deleteRequest;
            return this;
        }

        public final void setDeleteRequest(DeleteRequest deleteRequest) {
            this.deleteRequest = deleteRequest;
        }

        public WriteRequest build() {
            return new WriteRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WriteRequest> {
        public Builder putRequest(PutRequest var1);

        public Builder deleteRequest(DeleteRequest var1);
    }
}

