/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.CapacityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the amount of provisioned throughput capacity consumed on a table or an index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Capacity implements StructuredPojo, ToCopyableBuilder<Capacity.Builder, Capacity> {
    private final Double capacityUnits;

    private Capacity(BuilderImpl builder) {
        this.capacityUnits = builder.capacityUnits;
    }

    /**
     * <p>
     * The total number of capacity units consumed on a table or an index.
     * </p>
     * 
     * @return The total number of capacity units consumed on a table or an index.
     */
    public Double capacityUnits() {
        return capacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((capacityUnits() == null) ? 0 : capacityUnits().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capacity)) {
            return false;
        }
        Capacity other = (Capacity) obj;
        if (other.capacityUnits() == null ^ this.capacityUnits() == null) {
            return false;
        }
        if (other.capacityUnits() != null && !other.capacityUnits().equals(this.capacityUnits())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (capacityUnits() != null) {
            sb.append("CapacityUnits: ").append(capacityUnits()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityUnits":
            return Optional.of(clazz.cast(capacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CapacityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Capacity> {
        /**
         * <p>
         * The total number of capacity units consumed on a table or an index.
         * </p>
         * 
         * @param capacityUnits
         *        The total number of capacity units consumed on a table or an index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityUnits(Double capacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private Double capacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(Capacity model) {
            capacityUnits(model.capacityUnits);
        }

        public final Double getCapacityUnits() {
            return capacityUnits;
        }

        @Override
        public final Builder capacityUnits(Double capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        public final void setCapacityUnits(Double capacityUnits) {
            this.capacityUnits = capacityUnits;
        }

        @Override
        public Capacity build() {
            return new Capacity(this);
        }
    }
}
