/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeStream</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStreamResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeStreamResponse.Builder, DescribeStreamResponse> {
    private final StreamDescription streamDescription;

    private DescribeStreamResponse(BuilderImpl builder) {
        this.streamDescription = builder.streamDescription;
    }

    /**
     * <p>
     * A complete description of the stream, including its creation date and time, the DynamoDB table associated with
     * the stream, the shard IDs within the stream, and the beginning and ending sequence numbers of stream records
     * within the shards.
     * </p>
     * 
     * @return A complete description of the stream, including its creation date and time, the DynamoDB table associated
     *         with the stream, the shard IDs within the stream, and the beginning and ending sequence numbers of stream
     *         records within the shards.
     */
    public StreamDescription streamDescription() {
        return streamDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamDescription() == null) ? 0 : streamDescription().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamResponse)) {
            return false;
        }
        DescribeStreamResponse other = (DescribeStreamResponse) obj;
        if (other.streamDescription() == null ^ this.streamDescription() == null) {
            return false;
        }
        if (other.streamDescription() != null && !other.streamDescription().equals(this.streamDescription())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (streamDescription() != null) {
            sb.append("StreamDescription: ").append(streamDescription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamDescription":
            return Optional.of(clazz.cast(streamDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStreamResponse> {
        /**
         * <p>
         * A complete description of the stream, including its creation date and time, the DynamoDB table associated
         * with the stream, the shard IDs within the stream, and the beginning and ending sequence numbers of stream
         * records within the shards.
         * </p>
         * 
         * @param streamDescription
         *        A complete description of the stream, including its creation date and time, the DynamoDB table
         *        associated with the stream, the shard IDs within the stream, and the beginning and ending sequence
         *        numbers of stream records within the shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamDescription(StreamDescription streamDescription);
    }

    static final class BuilderImpl implements Builder {
        private StreamDescription streamDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamResponse model) {
            streamDescription(model.streamDescription);
        }

        public final StreamDescription.Builder getStreamDescription() {
            return streamDescription != null ? streamDescription.toBuilder() : null;
        }

        @Override
        public final Builder streamDescription(StreamDescription streamDescription) {
            this.streamDescription = streamDescription;
            return this;
        }

        public final void setStreamDescription(StreamDescription.BuilderImpl streamDescription) {
            this.streamDescription = streamDescription != null ? streamDescription.build() : null;
        }

        @Override
        public DescribeStreamResponse build() {
            return new DescribeStreamResponse(this);
        }
    }
}
