/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTimeToLiveResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeTimeToLiveResponse.Builder, DescribeTimeToLiveResponse> {
    private final TimeToLiveDescription timeToLiveDescription;

    private DescribeTimeToLiveResponse(BuilderImpl builder) {
        this.timeToLiveDescription = builder.timeToLiveDescription;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public TimeToLiveDescription timeToLiveDescription() {
        return timeToLiveDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timeToLiveDescription() == null) ? 0 : timeToLiveDescription().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTimeToLiveResponse)) {
            return false;
        }
        DescribeTimeToLiveResponse other = (DescribeTimeToLiveResponse) obj;
        if (other.timeToLiveDescription() == null ^ this.timeToLiveDescription() == null) {
            return false;
        }
        if (other.timeToLiveDescription() != null && !other.timeToLiveDescription().equals(this.timeToLiveDescription())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (timeToLiveDescription() != null) {
            sb.append("TimeToLiveDescription: ").append(timeToLiveDescription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeToLiveDescription":
            return Optional.of(clazz.cast(timeToLiveDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTimeToLiveResponse> {
        /**
         * <p/>
         * 
         * @param timeToLiveDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLiveDescription(TimeToLiveDescription timeToLiveDescription);
    }

    static final class BuilderImpl implements Builder {
        private TimeToLiveDescription timeToLiveDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTimeToLiveResponse model) {
            timeToLiveDescription(model.timeToLiveDescription);
        }

        public final TimeToLiveDescription.Builder getTimeToLiveDescription() {
            return timeToLiveDescription != null ? timeToLiveDescription.toBuilder() : null;
        }

        @Override
        public final Builder timeToLiveDescription(TimeToLiveDescription timeToLiveDescription) {
            this.timeToLiveDescription = timeToLiveDescription;
            return this;
        }

        public final void setTimeToLiveDescription(TimeToLiveDescription.BuilderImpl timeToLiveDescription) {
            this.timeToLiveDescription = timeToLiveDescription != null ? timeToLiveDescription.build() : null;
        }

        @Override
        public DescribeTimeToLiveResponse build() {
            return new DescribeTimeToLiveResponse(this);
        }
    }
}
