/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>GetRecords</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetRecordsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetRecordsRequest.Builder, GetRecordsRequest> {
    private final String shardIterator;

    private final Integer limit;

    private GetRecordsRequest(BuilderImpl builder) {
        this.shardIterator = builder.shardIterator;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * A shard iterator that was retrieved from a previous GetShardIterator operation. This iterator can be used to
     * access the stream records in this shard.
     * </p>
     * 
     * @return A shard iterator that was retrieved from a previous GetShardIterator operation. This iterator can be used
     *         to access the stream records in this shard.
     */
    public String shardIterator() {
        return shardIterator;
    }

    /**
     * <p>
     * The maximum number of records to return from the shard. The upper limit is 1000.
     * </p>
     * 
     * @return The maximum number of records to return from the shard. The upper limit is 1000.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((shardIterator() == null) ? 0 : shardIterator().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsRequest)) {
            return false;
        }
        GetRecordsRequest other = (GetRecordsRequest) obj;
        if (other.shardIterator() == null ^ this.shardIterator() == null) {
            return false;
        }
        if (other.shardIterator() != null && !other.shardIterator().equals(this.shardIterator())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (shardIterator() != null) {
            sb.append("ShardIterator: ").append(shardIterator()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardIterator":
            return Optional.of(clazz.cast(shardIterator()));
        case "Limit":
            return Optional.of(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetRecordsRequest> {
        /**
         * <p>
         * A shard iterator that was retrieved from a previous GetShardIterator operation. This iterator can be used to
         * access the stream records in this shard.
         * </p>
         * 
         * @param shardIterator
         *        A shard iterator that was retrieved from a previous GetShardIterator operation. This iterator can be
         *        used to access the stream records in this shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardIterator(String shardIterator);

        /**
         * <p>
         * The maximum number of records to return from the shard. The upper limit is 1000.
         * </p>
         * 
         * @param limit
         *        The maximum number of records to return from the shard. The upper limit is 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);
    }

    static final class BuilderImpl implements Builder {
        private String shardIterator;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsRequest model) {
            shardIterator(model.shardIterator);
            limit(model.limit);
        }

        public final String getShardIterator() {
            return shardIterator;
        }

        @Override
        public final Builder shardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
            return this;
        }

        public final void setShardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public GetRecordsRequest build() {
            return new GetRecordsRequest(this);
        }
    }
}
