/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>GetShardIterator</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetShardIteratorRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetShardIteratorRequest.Builder, GetShardIteratorRequest> {
    private final String streamArn;

    private final String shardId;

    private final String shardIteratorType;

    private final String sequenceNumber;

    private GetShardIteratorRequest(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.shardId = builder.shardId;
        this.shardIteratorType = builder.shardIteratorType;
        this.sequenceNumber = builder.sequenceNumber;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the stream.
     */
    public String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The identifier of the shard. The iterator will be returned for this shard ID.
     * </p>
     * 
     * @return The identifier of the shard. The iterator will be returned for this shard ID.
     */
    public String shardId() {
        return shardId;
    }

    /**
     * <p>
     * Determines how the shard iterator is used to start reading stream records from the shard:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a specific sequence number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a specific sequence
     * number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is the oldest record in
     * the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records whose age exceeds this
     * limit are subject to removal (trimming) from the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATEST</code> - Start reading just after the most recent stream record in the shard, so that you always
     * read the most recent data in the shard.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shardIteratorType}
     * will return {@link ShardIteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shardIteratorTypeString}.
     * </p>
     * 
     * @return Determines how the shard iterator is used to start reading stream records from the shard:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a specific sequence
     *         number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a specific
     *         sequence number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is the oldest
     *         record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records
     *         whose age exceeds this limit are subject to removal (trimming) from the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATEST</code> - Start reading just after the most recent stream record in the shard, so that you
     *         always read the most recent data in the shard.
     *         </p>
     *         </li>
     * @see ShardIteratorType
     */
    public ShardIteratorType shardIteratorType() {
        return ShardIteratorType.fromValue(shardIteratorType);
    }

    /**
     * <p>
     * Determines how the shard iterator is used to start reading stream records from the shard:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a specific sequence number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a specific sequence
     * number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is the oldest record in
     * the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records whose age exceeds this
     * limit are subject to removal (trimming) from the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATEST</code> - Start reading just after the most recent stream record in the shard, so that you always
     * read the most recent data in the shard.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shardIteratorType}
     * will return {@link ShardIteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shardIteratorTypeString}.
     * </p>
     * 
     * @return Determines how the shard iterator is used to start reading stream records from the shard:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a specific sequence
     *         number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a specific
     *         sequence number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is the oldest
     *         record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records
     *         whose age exceeds this limit are subject to removal (trimming) from the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATEST</code> - Start reading just after the most recent stream record in the shard, so that you
     *         always read the most recent data in the shard.
     *         </p>
     *         </li>
     * @see ShardIteratorType
     */
    public String shardIteratorTypeString() {
        return shardIteratorType;
    }

    /**
     * <p>
     * The sequence number of a stream record in the shard from which to start reading.
     * </p>
     * 
     * @return The sequence number of a stream record in the shard from which to start reading.
     */
    public String sequenceNumber() {
        return sequenceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamArn() == null) ? 0 : streamArn().hashCode());
        hashCode = 31 * hashCode + ((shardId() == null) ? 0 : shardId().hashCode());
        hashCode = 31 * hashCode + ((shardIteratorTypeString() == null) ? 0 : shardIteratorTypeString().hashCode());
        hashCode = 31 * hashCode + ((sequenceNumber() == null) ? 0 : sequenceNumber().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorRequest)) {
            return false;
        }
        GetShardIteratorRequest other = (GetShardIteratorRequest) obj;
        if (other.streamArn() == null ^ this.streamArn() == null) {
            return false;
        }
        if (other.streamArn() != null && !other.streamArn().equals(this.streamArn())) {
            return false;
        }
        if (other.shardId() == null ^ this.shardId() == null) {
            return false;
        }
        if (other.shardId() != null && !other.shardId().equals(this.shardId())) {
            return false;
        }
        if (other.shardIteratorTypeString() == null ^ this.shardIteratorTypeString() == null) {
            return false;
        }
        if (other.shardIteratorTypeString() != null && !other.shardIteratorTypeString().equals(this.shardIteratorTypeString())) {
            return false;
        }
        if (other.sequenceNumber() == null ^ this.sequenceNumber() == null) {
            return false;
        }
        if (other.sequenceNumber() != null && !other.sequenceNumber().equals(this.sequenceNumber())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (streamArn() != null) {
            sb.append("StreamArn: ").append(streamArn()).append(",");
        }
        if (shardId() != null) {
            sb.append("ShardId: ").append(shardId()).append(",");
        }
        if (shardIteratorTypeString() != null) {
            sb.append("ShardIteratorType: ").append(shardIteratorTypeString()).append(",");
        }
        if (sequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(sequenceNumber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.of(clazz.cast(streamArn()));
        case "ShardId":
            return Optional.of(clazz.cast(shardId()));
        case "ShardIteratorType":
            return Optional.of(clazz.cast(shardIteratorTypeString()));
        case "SequenceNumber":
            return Optional.of(clazz.cast(sequenceNumber()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetShardIteratorRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the stream.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) for the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The identifier of the shard. The iterator will be returned for this shard ID.
         * </p>
         * 
         * @param shardId
         *        The identifier of the shard. The iterator will be returned for this shard ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * Determines how the shard iterator is used to start reading stream records from the shard:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a specific sequence
         * number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a specific sequence
         * number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is the oldest record
         * in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records whose age
         * exceeds this limit are subject to removal (trimming) from the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATEST</code> - Start reading just after the most recent stream record in the shard, so that you always
         * read the most recent data in the shard.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shardIteratorType
         *        Determines how the shard iterator is used to start reading stream records from the shard:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a specific
         *        sequence number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a specific
         *        sequence number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is the oldest
         *        record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records
         *        whose age exceeds this limit are subject to removal (trimming) from the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATEST</code> - Start reading just after the most recent stream record in the shard, so that you
         *        always read the most recent data in the shard.
         *        </p>
         *        </li>
         * @see ShardIteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder shardIteratorType(String shardIteratorType);

        /**
         * <p>
         * Determines how the shard iterator is used to start reading stream records from the shard:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a specific sequence
         * number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a specific sequence
         * number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is the oldest record
         * in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records whose age
         * exceeds this limit are subject to removal (trimming) from the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATEST</code> - Start reading just after the most recent stream record in the shard, so that you always
         * read the most recent data in the shard.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shardIteratorType
         *        Determines how the shard iterator is used to start reading stream records from the shard:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a specific
         *        sequence number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a specific
         *        sequence number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is the oldest
         *        record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records
         *        whose age exceeds this limit are subject to removal (trimming) from the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATEST</code> - Start reading just after the most recent stream record in the shard, so that you
         *        always read the most recent data in the shard.
         *        </p>
         *        </li>
         * @see ShardIteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder shardIteratorType(ShardIteratorType shardIteratorType);

        /**
         * <p>
         * The sequence number of a stream record in the shard from which to start reading.
         * </p>
         * 
         * @param sequenceNumber
         *        The sequence number of a stream record in the shard from which to start reading.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);
    }

    static final class BuilderImpl implements Builder {
        private String streamArn;

        private String shardId;

        private String shardIteratorType;

        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorRequest model) {
            streamArn(model.streamArn);
            shardId(model.shardId);
            shardIteratorType(model.shardIteratorType);
            sequenceNumber(model.sequenceNumber);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getShardId() {
            return shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getShardIteratorType() {
            return shardIteratorType;
        }

        @Override
        public final Builder shardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
            return this;
        }

        @Override
        public final Builder shardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType.toString());
            return this;
        }

        public final void setShardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public GetShardIteratorRequest build() {
            return new GetShardIteratorRequest(this);
        }
    }
}
