/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>ListStreams</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStreamsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListStreamsResponse.Builder, ListStreamsResponse> {
    private final List<Stream> streams;

    private final String lastEvaluatedStreamArn;

    private ListStreamsResponse(BuilderImpl builder) {
        this.streams = builder.streams;
        this.lastEvaluatedStreamArn = builder.lastEvaluatedStreamArn;
    }

    /**
     * <p>
     * A list of stream descriptors associated with the current account and endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of stream descriptors associated with the current account and endpoint.
     */
    public List<Stream> streams() {
        return streams;
    }

    /**
     * <p>
     * The stream ARN of the item where the operation stopped, inclusive of the previous result set. Use this value to
     * start a new operation, excluding this value in the new request.
     * </p>
     * <p>
     * If <code>LastEvaluatedStreamArn</code> is empty, then the "last page" of results has been processed and there is
     * no more data to be retrieved.
     * </p>
     * <p>
     * If <code>LastEvaluatedStreamArn</code> is not empty, it does not necessarily mean that there is more data in the
     * result set. The only way to know when you have reached the end of the result set is when
     * <code>LastEvaluatedStreamArn</code> is empty.
     * </p>
     * 
     * @return The stream ARN of the item where the operation stopped, inclusive of the previous result set. Use this
     *         value to start a new operation, excluding this value in the new request.</p>
     *         <p>
     *         If <code>LastEvaluatedStreamArn</code> is empty, then the "last page" of results has been processed and
     *         there is no more data to be retrieved.
     *         </p>
     *         <p>
     *         If <code>LastEvaluatedStreamArn</code> is not empty, it does not necessarily mean that there is more data
     *         in the result set. The only way to know when you have reached the end of the result set is when
     *         <code>LastEvaluatedStreamArn</code> is empty.
     */
    public String lastEvaluatedStreamArn() {
        return lastEvaluatedStreamArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streams() == null) ? 0 : streams().hashCode());
        hashCode = 31 * hashCode + ((lastEvaluatedStreamArn() == null) ? 0 : lastEvaluatedStreamArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse) obj;
        if (other.streams() == null ^ this.streams() == null) {
            return false;
        }
        if (other.streams() != null && !other.streams().equals(this.streams())) {
            return false;
        }
        if (other.lastEvaluatedStreamArn() == null ^ this.lastEvaluatedStreamArn() == null) {
            return false;
        }
        if (other.lastEvaluatedStreamArn() != null && !other.lastEvaluatedStreamArn().equals(this.lastEvaluatedStreamArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (streams() != null) {
            sb.append("Streams: ").append(streams()).append(",");
        }
        if (lastEvaluatedStreamArn() != null) {
            sb.append("LastEvaluatedStreamArn: ").append(lastEvaluatedStreamArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Streams":
            return Optional.of(clazz.cast(streams()));
        case "LastEvaluatedStreamArn":
            return Optional.of(clazz.cast(lastEvaluatedStreamArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListStreamsResponse> {
        /**
         * <p>
         * A list of stream descriptors associated with the current account and endpoint.
         * </p>
         * 
         * @param streams
         *        A list of stream descriptors associated with the current account and endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(Collection<Stream> streams);

        /**
         * <p>
         * A list of stream descriptors associated with the current account and endpoint.
         * </p>
         * 
         * @param streams
         *        A list of stream descriptors associated with the current account and endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(Stream... streams);

        /**
         * <p>
         * The stream ARN of the item where the operation stopped, inclusive of the previous result set. Use this value
         * to start a new operation, excluding this value in the new request.
         * </p>
         * <p>
         * If <code>LastEvaluatedStreamArn</code> is empty, then the "last page" of results has been processed and there
         * is no more data to be retrieved.
         * </p>
         * <p>
         * If <code>LastEvaluatedStreamArn</code> is not empty, it does not necessarily mean that there is more data in
         * the result set. The only way to know when you have reached the end of the result set is when
         * <code>LastEvaluatedStreamArn</code> is empty.
         * </p>
         * 
         * @param lastEvaluatedStreamArn
         *        The stream ARN of the item where the operation stopped, inclusive of the previous result set. Use this
         *        value to start a new operation, excluding this value in the new request.</p>
         *        <p>
         *        If <code>LastEvaluatedStreamArn</code> is empty, then the "last page" of results has been processed
         *        and there is no more data to be retrieved.
         *        </p>
         *        <p>
         *        If <code>LastEvaluatedStreamArn</code> is not empty, it does not necessarily mean that there is more
         *        data in the result set. The only way to know when you have reached the end of the result set is when
         *        <code>LastEvaluatedStreamArn</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedStreamArn(String lastEvaluatedStreamArn);
    }

    static final class BuilderImpl implements Builder {
        private List<Stream> streams;

        private String lastEvaluatedStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            streams(model.streams);
            lastEvaluatedStreamArn(model.lastEvaluatedStreamArn);
        }

        public final Collection<Stream.Builder> getStreams() {
            return streams != null ? streams.stream().map(Stream::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder streams(Collection<Stream> streams) {
            this.streams = StreamListCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Stream... streams) {
            streams(Arrays.asList(streams));
            return this;
        }

        public final void setStreams(Collection<Stream.BuilderImpl> streams) {
            this.streams = StreamListCopier.copyFromBuilder(streams);
        }

        public final String getLastEvaluatedStreamArn() {
            return lastEvaluatedStreamArn;
        }

        @Override
        public final Builder lastEvaluatedStreamArn(String lastEvaluatedStreamArn) {
            this.lastEvaluatedStreamArn = lastEvaluatedStreamArn;
            return this;
        }

        public final void setLastEvaluatedStreamArn(String lastEvaluatedStreamArn) {
            this.lastEvaluatedStreamArn = lastEvaluatedStreamArn;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }
    }
}
