/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ListTables</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTablesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListTablesRequest.Builder, ListTablesRequest> {
    private final String exclusiveStartTableName;

    private final Integer limit;

    private ListTablesRequest(BuilderImpl builder) {
        this.exclusiveStartTableName = builder.exclusiveStartTableName;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The first table name that this operation will evaluate. Use the value that was returned for
     * <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of results.
     * </p>
     * 
     * @return The first table name that this operation will evaluate. Use the value that was returned for
     *         <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of
     *         results.
     */
    public String exclusiveStartTableName() {
        return exclusiveStartTableName;
    }

    /**
     * <p>
     * A maximum number of table names to return. If this parameter is not specified, the limit is 100.
     * </p>
     * 
     * @return A maximum number of table names to return. If this parameter is not specified, the limit is 100.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((exclusiveStartTableName() == null) ? 0 : exclusiveStartTableName().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesRequest)) {
            return false;
        }
        ListTablesRequest other = (ListTablesRequest) obj;
        if (other.exclusiveStartTableName() == null ^ this.exclusiveStartTableName() == null) {
            return false;
        }
        if (other.exclusiveStartTableName() != null && !other.exclusiveStartTableName().equals(this.exclusiveStartTableName())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (exclusiveStartTableName() != null) {
            sb.append("ExclusiveStartTableName: ").append(exclusiveStartTableName()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExclusiveStartTableName":
            return Optional.of(clazz.cast(exclusiveStartTableName()));
        case "Limit":
            return Optional.of(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListTablesRequest> {
        /**
         * <p>
         * The first table name that this operation will evaluate. Use the value that was returned for
         * <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of results.
         * </p>
         * 
         * @param exclusiveStartTableName
         *        The first table name that this operation will evaluate. Use the value that was returned for
         *        <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartTableName(String exclusiveStartTableName);

        /**
         * <p>
         * A maximum number of table names to return. If this parameter is not specified, the limit is 100.
         * </p>
         * 
         * @param limit
         *        A maximum number of table names to return. If this parameter is not specified, the limit is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);
    }

    static final class BuilderImpl implements Builder {
        private String exclusiveStartTableName;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesRequest model) {
            exclusiveStartTableName(model.exclusiveStartTableName);
            limit(model.limit);
        }

        public final String getExclusiveStartTableName() {
            return exclusiveStartTableName;
        }

        @Override
        public final Builder exclusiveStartTableName(String exclusiveStartTableName) {
            this.exclusiveStartTableName = exclusiveStartTableName;
            return this;
        }

        public final void setExclusiveStartTableName(String exclusiveStartTableName) {
            this.exclusiveStartTableName = exclusiveStartTableName;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public ListTablesRequest build() {
            return new ListTablesRequest(this);
        }
    }
}
