/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateTimeToLiveResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateTimeToLiveResponse.Builder, UpdateTimeToLiveResponse> {
    private final TimeToLiveSpecification timeToLiveSpecification;

    private UpdateTimeToLiveResponse(BuilderImpl builder) {
        this.timeToLiveSpecification = builder.timeToLiveSpecification;
    }

    /**
     * <p>
     * Represents the output of an <code>UpdateTimeToLive</code> operation.
     * </p>
     * 
     * @return Represents the output of an <code>UpdateTimeToLive</code> operation.
     */
    public TimeToLiveSpecification timeToLiveSpecification() {
        return timeToLiveSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timeToLiveSpecification() == null) ? 0 : timeToLiveSpecification().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTimeToLiveResponse)) {
            return false;
        }
        UpdateTimeToLiveResponse other = (UpdateTimeToLiveResponse) obj;
        if (other.timeToLiveSpecification() == null ^ this.timeToLiveSpecification() == null) {
            return false;
        }
        if (other.timeToLiveSpecification() != null && !other.timeToLiveSpecification().equals(this.timeToLiveSpecification())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (timeToLiveSpecification() != null) {
            sb.append("TimeToLiveSpecification: ").append(timeToLiveSpecification()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeToLiveSpecification":
            return Optional.of(clazz.cast(timeToLiveSpecification()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateTimeToLiveResponse> {
        /**
         * <p>
         * Represents the output of an <code>UpdateTimeToLive</code> operation.
         * </p>
         * 
         * @param timeToLiveSpecification
         *        Represents the output of an <code>UpdateTimeToLive</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification);
    }

    static final class BuilderImpl implements Builder {
        private TimeToLiveSpecification timeToLiveSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTimeToLiveResponse model) {
            timeToLiveSpecification(model.timeToLiveSpecification);
        }

        public final TimeToLiveSpecification.Builder getTimeToLiveSpecification() {
            return timeToLiveSpecification != null ? timeToLiveSpecification.toBuilder() : null;
        }

        @Override
        public final Builder timeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        public final void setTimeToLiveSpecification(TimeToLiveSpecification.BuilderImpl timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification != null ? timeToLiveSpecification.build() : null;
        }

        @Override
        public UpdateTimeToLiveResponse build() {
            return new UpdateTimeToLiveResponse(this);
        }
    }
}
