/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.services.dynamodb.transform.GlobalSecondaryIndexDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GlobalSecondaryIndexDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, GlobalSecondaryIndexDescription> {
    private final String indexName;
    private final List<KeySchemaElement> keySchema;
    private final Projection projection;
    private final String indexStatus;
    private final Boolean backfilling;
    private final ProvisionedThroughputDescription provisionedThroughput;
    private final Long indexSizeBytes;
    private final Long itemCount;
    private final String indexArn;

    private GlobalSecondaryIndexDescription(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
        this.indexStatus = builder.indexStatus;
        this.backfilling = builder.backfilling;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.indexSizeBytes = builder.indexSizeBytes;
        this.itemCount = builder.itemCount;
        this.indexArn = builder.indexArn;
    }

    public String indexName() {
        return this.indexName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public Projection projection() {
        return this.projection;
    }

    public IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public String indexStatusString() {
        return this.indexStatus;
    }

    public Boolean backfilling() {
        return this.backfilling;
    }

    public ProvisionedThroughputDescription provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Long indexSizeBytes() {
        return this.indexSizeBytes;
    }

    public Long itemCount() {
        return this.itemCount;
    }

    public String indexArn() {
        return this.indexArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.indexName() == null ? 0 : this.indexName().hashCode());
        hashCode = 31 * hashCode + (this.keySchema() == null ? 0 : this.keySchema().hashCode());
        hashCode = 31 * hashCode + (this.projection() == null ? 0 : this.projection().hashCode());
        hashCode = 31 * hashCode + (this.indexStatusString() == null ? 0 : this.indexStatusString().hashCode());
        hashCode = 31 * hashCode + (this.backfilling() == null ? 0 : this.backfilling().hashCode());
        hashCode = 31 * hashCode + (this.provisionedThroughput() == null ? 0 : this.provisionedThroughput().hashCode());
        hashCode = 31 * hashCode + (this.indexSizeBytes() == null ? 0 : this.indexSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.itemCount() == null ? 0 : this.itemCount().hashCode());
        hashCode = 31 * hashCode + (this.indexArn() == null ? 0 : this.indexArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalSecondaryIndexDescription)) {
            return false;
        }
        GlobalSecondaryIndexDescription other = (GlobalSecondaryIndexDescription)obj;
        if (other.indexName() == null ^ this.indexName() == null) {
            return false;
        }
        if (other.indexName() != null && !other.indexName().equals(this.indexName())) {
            return false;
        }
        if (other.keySchema() == null ^ this.keySchema() == null) {
            return false;
        }
        if (other.keySchema() != null && !other.keySchema().equals(this.keySchema())) {
            return false;
        }
        if (other.projection() == null ^ this.projection() == null) {
            return false;
        }
        if (other.projection() != null && !other.projection().equals(this.projection())) {
            return false;
        }
        if (other.indexStatusString() == null ^ this.indexStatusString() == null) {
            return false;
        }
        if (other.indexStatusString() != null && !other.indexStatusString().equals(this.indexStatusString())) {
            return false;
        }
        if (other.backfilling() == null ^ this.backfilling() == null) {
            return false;
        }
        if (other.backfilling() != null && !other.backfilling().equals(this.backfilling())) {
            return false;
        }
        if (other.provisionedThroughput() == null ^ this.provisionedThroughput() == null) {
            return false;
        }
        if (other.provisionedThroughput() != null && !other.provisionedThroughput().equals(this.provisionedThroughput())) {
            return false;
        }
        if (other.indexSizeBytes() == null ^ this.indexSizeBytes() == null) {
            return false;
        }
        if (other.indexSizeBytes() != null && !other.indexSizeBytes().equals(this.indexSizeBytes())) {
            return false;
        }
        if (other.itemCount() == null ^ this.itemCount() == null) {
            return false;
        }
        if (other.itemCount() != null && !other.itemCount().equals(this.itemCount())) {
            return false;
        }
        if (other.indexArn() == null ^ this.indexArn() == null) {
            return false;
        }
        return other.indexArn() == null || other.indexArn().equals(this.indexArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.indexName() != null) {
            sb.append("IndexName: ").append(this.indexName()).append(",");
        }
        if (this.keySchema() != null) {
            sb.append("KeySchema: ").append(this.keySchema()).append(",");
        }
        if (this.projection() != null) {
            sb.append("Projection: ").append(this.projection()).append(",");
        }
        if (this.indexStatusString() != null) {
            sb.append("IndexStatus: ").append(this.indexStatusString()).append(",");
        }
        if (this.backfilling() != null) {
            sb.append("Backfilling: ").append(this.backfilling()).append(",");
        }
        if (this.provisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(this.provisionedThroughput()).append(",");
        }
        if (this.indexSizeBytes() != null) {
            sb.append("IndexSizeBytes: ").append(this.indexSizeBytes()).append(",");
        }
        if (this.itemCount() != null) {
            sb.append("ItemCount: ").append(this.itemCount()).append(",");
        }
        if (this.indexArn() != null) {
            sb.append("IndexArn: ").append(this.indexArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.of(clazz.cast(this.indexName()));
            }
            case "KeySchema": {
                return Optional.of(clazz.cast(this.keySchema()));
            }
            case "Projection": {
                return Optional.of(clazz.cast(this.projection()));
            }
            case "IndexStatus": {
                return Optional.of(clazz.cast(this.indexStatusString()));
            }
            case "Backfilling": {
                return Optional.of(clazz.cast(this.backfilling()));
            }
            case "ProvisionedThroughput": {
                return Optional.of(clazz.cast(this.provisionedThroughput()));
            }
            case "IndexSizeBytes": {
                return Optional.of(clazz.cast(this.indexSizeBytes()));
            }
            case "ItemCount": {
                return Optional.of(clazz.cast(this.itemCount()));
            }
            case "IndexArn": {
                return Optional.of(clazz.cast(this.indexArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GlobalSecondaryIndexDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private List<KeySchemaElement> keySchema;
        private Projection projection;
        private String indexStatus;
        private Boolean backfilling;
        private ProvisionedThroughputDescription provisionedThroughput;
        private Long indexSizeBytes;
        private Long itemCount;
        private String indexArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalSecondaryIndexDescription model) {
            this.indexName(model.indexName);
            this.keySchema(model.keySchema);
            this.projection(model.projection);
            this.indexStatus(model.indexStatus);
            this.backfilling(model.backfilling);
            this.provisionedThroughput(model.provisionedThroughput);
            this.indexSizeBytes(model.indexSizeBytes);
            this.itemCount(model.itemCount);
            this.indexArn(model.indexArn);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<KeySchemaElement.Builder> getKeySchema() {
            return this.keySchema != null ? (Collection)this.keySchema.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final Projection.Builder getProjection() {
            return this.projection != null ? this.projection.toBuilder() : null;
        }

        @Override
        public final Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public final void setProjection(Projection.BuilderImpl projection) {
            this.projection = projection != null ? projection.build() : null;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus.toString());
            return this;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        public final Boolean getBackfilling() {
            return this.backfilling;
        }

        @Override
        public final Builder backfilling(Boolean backfilling) {
            this.backfilling = backfilling;
            return this;
        }

        public final void setBackfilling(Boolean backfilling) {
            this.backfilling = backfilling;
        }

        public final ProvisionedThroughputDescription.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughputDescription.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final Long getIndexSizeBytes() {
            return this.indexSizeBytes;
        }

        @Override
        public final Builder indexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
            return this;
        }

        public final void setIndexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
        }

        public final Long getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        public GlobalSecondaryIndexDescription build() {
            return new GlobalSecondaryIndexDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GlobalSecondaryIndexDescription> {
        public Builder indexName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder projection(Projection var1);

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder backfilling(Boolean var1);

        public Builder provisionedThroughput(ProvisionedThroughputDescription var1);

        public Builder indexSizeBytes(Long var1);

        public Builder itemCount(Long var1);

        public Builder indexArn(String var1);
    }
}

