/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.dynamodb.model.TableNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTablesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTablesResponse> {
    private final List<String> tableNames;
    private final String lastEvaluatedTableName;

    private ListTablesResponse(BuilderImpl builder) {
        this.tableNames = builder.tableNames;
        this.lastEvaluatedTableName = builder.lastEvaluatedTableName;
    }

    public List<String> tableNames() {
        return this.tableNames;
    }

    public String lastEvaluatedTableName() {
        return this.lastEvaluatedTableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tableNames() == null ? 0 : this.tableNames().hashCode());
        hashCode = 31 * hashCode + (this.lastEvaluatedTableName() == null ? 0 : this.lastEvaluatedTableName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesResponse)) {
            return false;
        }
        ListTablesResponse other = (ListTablesResponse)((Object)obj);
        if (other.tableNames() == null ^ this.tableNames() == null) {
            return false;
        }
        if (other.tableNames() != null && !other.tableNames().equals(this.tableNames())) {
            return false;
        }
        if (other.lastEvaluatedTableName() == null ^ this.lastEvaluatedTableName() == null) {
            return false;
        }
        return other.lastEvaluatedTableName() == null || other.lastEvaluatedTableName().equals(this.lastEvaluatedTableName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tableNames() != null) {
            sb.append("TableNames: ").append(this.tableNames()).append(",");
        }
        if (this.lastEvaluatedTableName() != null) {
            sb.append("LastEvaluatedTableName: ").append(this.lastEvaluatedTableName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableNames": {
                return Optional.of(clazz.cast(this.tableNames()));
            }
            case "LastEvaluatedTableName": {
                return Optional.of(clazz.cast(this.lastEvaluatedTableName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> tableNames;
        private String lastEvaluatedTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesResponse model) {
            this.tableNames(model.tableNames);
            this.lastEvaluatedTableName(model.lastEvaluatedTableName);
        }

        public final Collection<String> getTableNames() {
            return this.tableNames;
        }

        @Override
        public final Builder tableNames(Collection<String> tableNames) {
            this.tableNames = TableNameListCopier.copy(tableNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableNames(String ... tableNames) {
            this.tableNames(Arrays.asList(tableNames));
            return this;
        }

        public final void setTableNames(Collection<String> tableNames) {
            this.tableNames = TableNameListCopier.copy(tableNames);
        }

        public final String getLastEvaluatedTableName() {
            return this.lastEvaluatedTableName;
        }

        @Override
        public final Builder lastEvaluatedTableName(String lastEvaluatedTableName) {
            this.lastEvaluatedTableName = lastEvaluatedTableName;
            return this;
        }

        public final void setLastEvaluatedTableName(String lastEvaluatedTableName) {
            this.lastEvaluatedTableName = lastEvaluatedTableName;
        }

        public ListTablesResponse build() {
            return new ListTablesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTablesResponse> {
        public Builder tableNames(Collection<String> var1);

        public Builder tableNames(String ... var1);

        public Builder lastEvaluatedTableName(String var1);
    }
}

