/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.SequenceNumberRange;
import software.amazon.awssdk.services.dynamodb.transform.ShardMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Shard
implements StructuredPojo,
ToCopyableBuilder<Builder, Shard> {
    private final String shardId;
    private final SequenceNumberRange sequenceNumberRange;
    private final String parentShardId;

    private Shard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.sequenceNumberRange = builder.sequenceNumberRange;
        this.parentShardId = builder.parentShardId;
    }

    public String shardId() {
        return this.shardId;
    }

    public SequenceNumberRange sequenceNumberRange() {
        return this.sequenceNumberRange;
    }

    public String parentShardId() {
        return this.parentShardId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.shardId() == null ? 0 : this.shardId().hashCode());
        hashCode = 31 * hashCode + (this.sequenceNumberRange() == null ? 0 : this.sequenceNumberRange().hashCode());
        hashCode = 31 * hashCode + (this.parentShardId() == null ? 0 : this.parentShardId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard)obj;
        if (other.shardId() == null ^ this.shardId() == null) {
            return false;
        }
        if (other.shardId() != null && !other.shardId().equals(this.shardId())) {
            return false;
        }
        if (other.sequenceNumberRange() == null ^ this.sequenceNumberRange() == null) {
            return false;
        }
        if (other.sequenceNumberRange() != null && !other.sequenceNumberRange().equals(this.sequenceNumberRange())) {
            return false;
        }
        if (other.parentShardId() == null ^ this.parentShardId() == null) {
            return false;
        }
        return other.parentShardId() == null || other.parentShardId().equals(this.parentShardId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.shardId() != null) {
            sb.append("ShardId: ").append(this.shardId()).append(",");
        }
        if (this.sequenceNumberRange() != null) {
            sb.append("SequenceNumberRange: ").append(this.sequenceNumberRange()).append(",");
        }
        if (this.parentShardId() != null) {
            sb.append("ParentShardId: ").append(this.parentShardId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardId": {
                return Optional.of(clazz.cast(this.shardId()));
            }
            case "SequenceNumberRange": {
                return Optional.of(clazz.cast(this.sequenceNumberRange()));
            }
            case "ParentShardId": {
                return Optional.of(clazz.cast(this.parentShardId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String shardId;
        private SequenceNumberRange sequenceNumberRange;
        private String parentShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(Shard model) {
            this.shardId(model.shardId);
            this.sequenceNumberRange(model.sequenceNumberRange);
            this.parentShardId(model.parentShardId);
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final SequenceNumberRange.Builder getSequenceNumberRange() {
            return this.sequenceNumberRange != null ? this.sequenceNumberRange.toBuilder() : null;
        }

        @Override
        public final Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
            return this;
        }

        public final void setSequenceNumberRange(SequenceNumberRange.BuilderImpl sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange != null ? sequenceNumberRange.build() : null;
        }

        public final String getParentShardId() {
            return this.parentShardId;
        }

        @Override
        public final Builder parentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
            return this;
        }

        public final void setParentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
        }

        public Shard build() {
            return new Shard(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Shard> {
        public Builder shardId(String var1);

        public Builder sequenceNumberRange(SequenceNumberRange var1);

        public Builder parentShardId(String var1);
    }
}

