/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DescribeTable</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTableRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeTableRequest.Builder, DescribeTableRequest> {
    private final String tableName;

    private DescribeTableRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
    }

    /**
     * <p>
     * The name of the table to describe.
     * </p>
     * 
     * @return The name of the table to describe.
     */
    public String tableName() {
        return tableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableRequest)) {
            return false;
        }
        DescribeTableRequest other = (DescribeTableRequest) obj;
        return Objects.equals(tableName(), other.tableName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.of(clazz.cast(tableName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTableRequest> {
        /**
         * <p>
         * The name of the table to describe.
         * </p>
         * 
         * @param tableName
         *        The name of the table to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableRequest model) {
            tableName(model.tableName);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public DescribeTableRequest build() {
            return new DescribeTableRequest(this);
        }
    }
}
