/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of concurrent table requests (cumulative number of tables in the <code>CREATING</code>,
 * <code>DELETING</code> or <code>UPDATING</code> state) exceeds the maximum allowed of 10.
 * </p>
 * <p>
 * Also, for tables with secondary indexes, only one of those tables can be in the <code>CREATING</code> state at any
 * point in time. Do not attempt to create more than one such table simultaneously.
 * </p>
 * <p>
 * The total limit of tables in the <code>ACTIVE</code> state is 250.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LimitExceededException extends DynamoDBException implements
        ToCopyableBuilder<LimitExceededException.Builder, LimitExceededException> {
    private LimitExceededException(BuilderImpl builder) {
        super(builder.message);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public interface Builder extends CopyableBuilder<Builder, LimitExceededException> {
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(LimitExceededException model) {
            this.message = model.getMessage();
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public LimitExceededException build() {
            return new LimitExceededException(this);
        }
    }
}
