/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>ListTables</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTablesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListTablesResponse.Builder, ListTablesResponse> {
    private final List<String> tableNames;

    private final String lastEvaluatedTableName;

    private ListTablesResponse(BuilderImpl builder) {
        this.tableNames = builder.tableNames;
        this.lastEvaluatedTableName = builder.lastEvaluatedTableName;
    }

    /**
     * <p>
     * The names of the tables associated with the current account at the current endpoint. The maximum size of this
     * array is 100.
     * </p>
     * <p>
     * If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
     * <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and obtain the
     * next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the tables associated with the current account at the current endpoint. The maximum size of
     *         this array is 100.</p>
     *         <p>
     *         If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
     *         <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and obtain
     *         the next page of results.
     */
    public List<String> tableNames() {
        return tableNames;
    }

    /**
     * <p>
     * The name of the last table in the current page of results. Use this value as the
     * <code>ExclusiveStartTableName</code> in a new request to obtain the next page of results, until all the table
     * names are returned.
     * </p>
     * <p>
     * If you do not receive a <code>LastEvaluatedTableName</code> value in the response, this means that there are no
     * more table names to be retrieved.
     * </p>
     * 
     * @return The name of the last table in the current page of results. Use this value as the
     *         <code>ExclusiveStartTableName</code> in a new request to obtain the next page of results, until all the
     *         table names are returned.</p>
     *         <p>
     *         If you do not receive a <code>LastEvaluatedTableName</code> value in the response, this means that there
     *         are no more table names to be retrieved.
     */
    public String lastEvaluatedTableName() {
        return lastEvaluatedTableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableNames());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluatedTableName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesResponse)) {
            return false;
        }
        ListTablesResponse other = (ListTablesResponse) obj;
        return Objects.equals(tableNames(), other.tableNames())
                && Objects.equals(lastEvaluatedTableName(), other.lastEvaluatedTableName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (tableNames() != null) {
            sb.append("TableNames: ").append(tableNames()).append(",");
        }
        if (lastEvaluatedTableName() != null) {
            sb.append("LastEvaluatedTableName: ").append(lastEvaluatedTableName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableNames":
            return Optional.of(clazz.cast(tableNames()));
        case "LastEvaluatedTableName":
            return Optional.of(clazz.cast(lastEvaluatedTableName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListTablesResponse> {
        /**
         * <p>
         * The names of the tables associated with the current account at the current endpoint. The maximum size of this
         * array is 100.
         * </p>
         * <p>
         * If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
         * <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and obtain the
         * next page of results.
         * </p>
         * 
         * @param tableNames
         *        The names of the tables associated with the current account at the current endpoint. The maximum size
         *        of this array is 100.</p>
         *        <p>
         *        If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
         *        <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and
         *        obtain the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableNames(Collection<String> tableNames);

        /**
         * <p>
         * The names of the tables associated with the current account at the current endpoint. The maximum size of this
         * array is 100.
         * </p>
         * <p>
         * If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
         * <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and obtain the
         * next page of results.
         * </p>
         * 
         * @param tableNames
         *        The names of the tables associated with the current account at the current endpoint. The maximum size
         *        of this array is 100.</p>
         *        <p>
         *        If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
         *        <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and
         *        obtain the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableNames(String... tableNames);

        /**
         * <p>
         * The name of the last table in the current page of results. Use this value as the
         * <code>ExclusiveStartTableName</code> in a new request to obtain the next page of results, until all the table
         * names are returned.
         * </p>
         * <p>
         * If you do not receive a <code>LastEvaluatedTableName</code> value in the response, this means that there are
         * no more table names to be retrieved.
         * </p>
         * 
         * @param lastEvaluatedTableName
         *        The name of the last table in the current page of results. Use this value as the
         *        <code>ExclusiveStartTableName</code> in a new request to obtain the next page of results, until all
         *        the table names are returned.</p>
         *        <p>
         *        If you do not receive a <code>LastEvaluatedTableName</code> value in the response, this means that
         *        there are no more table names to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedTableName(String lastEvaluatedTableName);
    }

    static final class BuilderImpl implements Builder {
        private List<String> tableNames;

        private String lastEvaluatedTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesResponse model) {
            tableNames(model.tableNames);
            lastEvaluatedTableName(model.lastEvaluatedTableName);
        }

        public final Collection<String> getTableNames() {
            return tableNames;
        }

        @Override
        public final Builder tableNames(Collection<String> tableNames) {
            this.tableNames = TableNameListCopier.copy(tableNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableNames(String... tableNames) {
            tableNames(Arrays.asList(tableNames));
            return this;
        }

        public final void setTableNames(Collection<String> tableNames) {
            this.tableNames = TableNameListCopier.copy(tableNames);
        }

        public final String getLastEvaluatedTableName() {
            return lastEvaluatedTableName;
        }

        @Override
        public final Builder lastEvaluatedTableName(String lastEvaluatedTableName) {
            this.lastEvaluatedTableName = lastEvaluatedTableName;
            return this;
        }

        public final void setLastEvaluatedTableName(String lastEvaluatedTableName) {
            this.lastEvaluatedTableName = lastEvaluatedTableName;
        }

        @Override
        public ListTablesResponse build() {
            return new ListTablesResponse(this);
        }
    }
}
