/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * BatchGetItemResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class BatchGetItemResponseUnmarshaller implements Unmarshaller<BatchGetItemResponse, JsonUnmarshallerContext> {

    public BatchGetItemResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        BatchGetItemResponse.Builder batchGetItemResponseBuilder = BatchGetItemResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return batchGetItemResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Responses", targetDepth)) {
                    context.nextToken();
                    batchGetItemResponseBuilder
                            .responses(new MapUnmarshaller<String, java.util.List<java.util.Map<String, AttributeValue>>>(context
                                    .getUnmarshaller(String.class), new ListUnmarshaller<java.util.Map<String, AttributeValue>>(
                                    new MapUnmarshaller<String, AttributeValue>(context.getUnmarshaller(String.class),
                                            AttributeValueUnmarshaller.getInstance()))).unmarshall(context));
                }
                if (context.testExpression("UnprocessedKeys", targetDepth)) {
                    context.nextToken();
                    batchGetItemResponseBuilder.unprocessedKeys(new MapUnmarshaller<String, KeysAndAttributes>(context
                            .getUnmarshaller(String.class), KeysAndAttributesUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ConsumedCapacity", targetDepth)) {
                    context.nextToken();
                    batchGetItemResponseBuilder.consumedCapacity(new ListUnmarshaller<ConsumedCapacity>(
                            ConsumedCapacityUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return batchGetItemResponseBuilder.build();
    }

    private static final BatchGetItemResponseUnmarshaller INSTANCE = new BatchGetItemResponseUnmarshaller();

    public static BatchGetItemResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
