/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.services.dynamodb.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * DescribeStreamRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class DescribeStreamRequestModelMarshaller {

    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamArn").build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").build();
    private static final MarshallingInfo<String> EXCLUSIVESTARTSHARDID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExclusiveStartShardId").build();

    private static final DescribeStreamRequestModelMarshaller INSTANCE = new DescribeStreamRequestModelMarshaller();

    public static DescribeStreamRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DescribeStreamRequest describeStreamRequest, ProtocolMarshaller protocolMarshaller) {

        if (describeStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(describeStreamRequest.streamArn(), STREAMARN_BINDING);

            protocolMarshaller.marshall(describeStreamRequest.limit(), LIMIT_BINDING);

            protocolMarshaller.marshall(describeStreamRequest.exclusiveStartShardId(), EXCLUSIVESTARTSHARDID_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
