/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStreamsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListStreamsRequest> {
    private final String tableName;
    private final Integer limit;
    private final String exclusiveStartStreamArn;

    private ListStreamsRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.limit = builder.limit;
        this.exclusiveStartStreamArn = builder.exclusiveStartStreamArn;
    }

    public String tableName() {
        return this.tableName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartStreamArn() {
        return this.exclusiveStartStreamArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartStreamArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsRequest)) {
            return false;
        }
        ListStreamsRequest other = (ListStreamsRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.exclusiveStartStreamArn(), other.exclusiveStartStreamArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.exclusiveStartStreamArn() != null) {
            sb.append("ExclusiveStartStreamArn: ").append(this.exclusiveStartStreamArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "ExclusiveStartStreamArn": {
                return Optional.of(clazz.cast(this.exclusiveStartStreamArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private Integer limit;
        private String exclusiveStartStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsRequest model) {
            this.tableName(model.tableName);
            this.limit(model.limit);
            this.exclusiveStartStreamArn(model.exclusiveStartStreamArn);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartStreamArn() {
            return this.exclusiveStartStreamArn;
        }

        @Override
        public final Builder exclusiveStartStreamArn(String exclusiveStartStreamArn) {
            this.exclusiveStartStreamArn = exclusiveStartStreamArn;
            return this;
        }

        public final void setExclusiveStartStreamArn(String exclusiveStartStreamArn) {
            this.exclusiveStartStreamArn = exclusiveStartStreamArn;
        }

        public ListStreamsRequest build() {
            return new ListStreamsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStreamsRequest> {
        public Builder tableName(String var1);

        public Builder limit(Integer var1);

        public Builder exclusiveStartStreamArn(String var1);
    }
}

