/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.FilterConditionMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScanRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ScanRequest> {
    private final String tableName;
    private final String indexName;
    private final List<String> attributesToGet;
    private final Integer limit;
    private final String select;
    private final Map<String, Condition> scanFilter;
    private final String conditionalOperator;
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final String returnConsumedCapacity;
    private final Integer totalSegments;
    private final Integer segment;
    private final String projectionExpression;
    private final String filterExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;
    private final Boolean consistentRead;

    private ScanRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.attributesToGet = builder.attributesToGet;
        this.limit = builder.limit;
        this.select = builder.select;
        this.scanFilter = builder.scanFilter;
        this.conditionalOperator = builder.conditionalOperator;
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.totalSegments = builder.totalSegments;
        this.segment = builder.segment;
        this.projectionExpression = builder.projectionExpression;
        this.filterExpression = builder.filterExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
        this.consistentRead = builder.consistentRead;
    }

    public String tableName() {
        return this.tableName;
    }

    public String indexName() {
        return this.indexName;
    }

    public List<String> attributesToGet() {
        return this.attributesToGet;
    }

    public Integer limit() {
        return this.limit;
    }

    public Select select() {
        return Select.fromValue(this.select);
    }

    public String selectString() {
        return this.select;
    }

    public Map<String, Condition> scanFilter() {
        return this.scanFilter;
    }

    public ConditionalOperator conditionalOperator() {
        return ConditionalOperator.fromValue(this.conditionalOperator);
    }

    public String conditionalOperatorString() {
        return this.conditionalOperator;
    }

    public Map<String, AttributeValue> exclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityString() {
        return this.returnConsumedCapacity;
    }

    public Integer totalSegments() {
        return this.totalSegments;
    }

    public Integer segment() {
        return this.segment;
    }

    public String projectionExpression() {
        return this.projectionExpression;
    }

    public String filterExpression() {
        return this.filterExpression;
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesToGet());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionalOperatorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSegments());
        hashCode = 31 * hashCode + Objects.hashCode(this.segment());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistentRead());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanRequest)) {
            return false;
        }
        ScanRequest other = (ScanRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.attributesToGet(), other.attributesToGet()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.selectString(), other.selectString()) && Objects.equals(this.scanFilter(), other.scanFilter()) && Objects.equals(this.conditionalOperatorString(), other.conditionalOperatorString()) && Objects.equals(this.exclusiveStartKey(), other.exclusiveStartKey()) && Objects.equals(this.returnConsumedCapacityString(), other.returnConsumedCapacityString()) && Objects.equals(this.totalSegments(), other.totalSegments()) && Objects.equals(this.segment(), other.segment()) && Objects.equals(this.projectionExpression(), other.projectionExpression()) && Objects.equals(this.filterExpression(), other.filterExpression()) && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames()) && Objects.equals(this.expressionAttributeValues(), other.expressionAttributeValues()) && Objects.equals(this.consistentRead(), other.consistentRead());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.indexName() != null) {
            sb.append("IndexName: ").append(this.indexName()).append(",");
        }
        if (this.attributesToGet() != null) {
            sb.append("AttributesToGet: ").append(this.attributesToGet()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.selectString() != null) {
            sb.append("Select: ").append(this.selectString()).append(",");
        }
        if (this.scanFilter() != null) {
            sb.append("ScanFilter: ").append(this.scanFilter()).append(",");
        }
        if (this.conditionalOperatorString() != null) {
            sb.append("ConditionalOperator: ").append(this.conditionalOperatorString()).append(",");
        }
        if (this.exclusiveStartKey() != null) {
            sb.append("ExclusiveStartKey: ").append(this.exclusiveStartKey()).append(",");
        }
        if (this.returnConsumedCapacityString() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.returnConsumedCapacityString()).append(",");
        }
        if (this.totalSegments() != null) {
            sb.append("TotalSegments: ").append(this.totalSegments()).append(",");
        }
        if (this.segment() != null) {
            sb.append("Segment: ").append(this.segment()).append(",");
        }
        if (this.projectionExpression() != null) {
            sb.append("ProjectionExpression: ").append(this.projectionExpression()).append(",");
        }
        if (this.filterExpression() != null) {
            sb.append("FilterExpression: ").append(this.filterExpression()).append(",");
        }
        if (this.expressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.expressionAttributeNames()).append(",");
        }
        if (this.expressionAttributeValues() != null) {
            sb.append("ExpressionAttributeValues: ").append(this.expressionAttributeValues()).append(",");
        }
        if (this.consistentRead() != null) {
            sb.append("ConsistentRead: ").append(this.consistentRead()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "IndexName": {
                return Optional.of(clazz.cast(this.indexName()));
            }
            case "AttributesToGet": {
                return Optional.of(clazz.cast(this.attributesToGet()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "Select": {
                return Optional.of(clazz.cast(this.selectString()));
            }
            case "ScanFilter": {
                return Optional.of(clazz.cast(this.scanFilter()));
            }
            case "ConditionalOperator": {
                return Optional.of(clazz.cast(this.conditionalOperatorString()));
            }
            case "ExclusiveStartKey": {
                return Optional.of(clazz.cast(this.exclusiveStartKey()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.of(clazz.cast(this.returnConsumedCapacityString()));
            }
            case "TotalSegments": {
                return Optional.of(clazz.cast(this.totalSegments()));
            }
            case "Segment": {
                return Optional.of(clazz.cast(this.segment()));
            }
            case "ProjectionExpression": {
                return Optional.of(clazz.cast(this.projectionExpression()));
            }
            case "FilterExpression": {
                return Optional.of(clazz.cast(this.filterExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.of(clazz.cast(this.expressionAttributeNames()));
            }
            case "ExpressionAttributeValues": {
                return Optional.of(clazz.cast(this.expressionAttributeValues()));
            }
            case "ConsistentRead": {
                return Optional.of(clazz.cast(this.consistentRead()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String indexName;
        private List<String> attributesToGet;
        private Integer limit;
        private String select;
        private Map<String, Condition> scanFilter;
        private String conditionalOperator;
        private Map<String, AttributeValue> exclusiveStartKey;
        private String returnConsumedCapacity;
        private Integer totalSegments;
        private Integer segment;
        private String projectionExpression;
        private String filterExpression;
        private Map<String, String> expressionAttributeNames;
        private Map<String, AttributeValue> expressionAttributeValues;
        private Boolean consistentRead;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanRequest model) {
            this.tableName(model.tableName);
            this.indexName(model.indexName);
            this.attributesToGet(model.attributesToGet);
            this.limit(model.limit);
            this.select(model.select);
            this.scanFilter(model.scanFilter);
            this.conditionalOperator(model.conditionalOperator);
            this.exclusiveStartKey(model.exclusiveStartKey);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
            this.totalSegments(model.totalSegments);
            this.segment(model.segment);
            this.projectionExpression(model.projectionExpression);
            this.filterExpression(model.filterExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
            this.expressionAttributeValues(model.expressionAttributeValues);
            this.consistentRead(model.consistentRead);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<String> getAttributesToGet() {
            return this.attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getSelect() {
            return this.select;
        }

        @Override
        public final Builder select(String select) {
            this.select = select;
            return this;
        }

        @Override
        public final Builder select(Select select) {
            this.select(select.toString());
            return this;
        }

        public final void setSelect(String select) {
            this.select = select;
        }

        public final Map<String, Condition.Builder> getScanFilter() {
            return this.scanFilter != null ? CollectionUtils.mapValues(this.scanFilter, Condition::toBuilder) : null;
        }

        @Override
        public final Builder scanFilter(Map<String, Condition> scanFilter) {
            this.scanFilter = FilterConditionMapCopier.copy(scanFilter);
            return this;
        }

        public final void setScanFilter(Map<String, Condition.BuilderImpl> scanFilter) {
            this.scanFilter = FilterConditionMapCopier.copyFromBuilder(scanFilter);
        }

        public final String getConditionalOperator() {
            return this.conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final Map<String, AttributeValue.Builder> getExclusiveStartKey() {
            return this.exclusiveStartKey != null ? CollectionUtils.mapValues(this.exclusiveStartKey, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copy(exclusiveStartKey);
            return this;
        }

        public final void setExclusiveStartKey(Map<String, AttributeValue.BuilderImpl> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copyFromBuilder(exclusiveStartKey);
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final Integer getTotalSegments() {
            return this.totalSegments;
        }

        @Override
        public final Builder totalSegments(Integer totalSegments) {
            this.totalSegments = totalSegments;
            return this;
        }

        public final void setTotalSegments(Integer totalSegments) {
            this.totalSegments = totalSegments;
        }

        public final Integer getSegment() {
            return this.segment;
        }

        @Override
        public final Builder segment(Integer segment) {
            this.segment = segment;
            return this;
        }

        public final void setSegment(Integer segment) {
            this.segment = segment;
        }

        public final String getProjectionExpression() {
            return this.projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final String getFilterExpression() {
            return this.filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return this.expressionAttributeValues != null ? CollectionUtils.mapValues(this.expressionAttributeValues, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        public final Boolean getConsistentRead() {
            return this.consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public ScanRequest build() {
            return new ScanRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScanRequest> {
        public Builder tableName(String var1);

        public Builder indexName(String var1);

        public Builder attributesToGet(Collection<String> var1);

        public Builder attributesToGet(String ... var1);

        public Builder limit(Integer var1);

        public Builder select(String var1);

        public Builder select(Select var1);

        public Builder scanFilter(Map<String, Condition> var1);

        public Builder conditionalOperator(String var1);

        public Builder conditionalOperator(ConditionalOperator var1);

        public Builder exclusiveStartKey(Map<String, AttributeValue> var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder totalSegments(Integer var1);

        public Builder segment(Integer var1);

        public Builder projectionExpression(String var1);

        public Builder filterExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);

        public Builder consistentRead(Boolean var1);
    }
}

