/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinitionsCopier;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdateListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateTableRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateTableRequest> {
    private final List<AttributeDefinition> attributeDefinitions;
    private final String tableName;
    private final ProvisionedThroughput provisionedThroughput;
    private final List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;
    private final StreamSpecification streamSpecification;

    private UpdateTableRequest(BuilderImpl builder) {
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.globalSecondaryIndexUpdates = builder.globalSecondaryIndexUpdates;
        this.streamSpecification = builder.streamSpecification;
    }

    public List<AttributeDefinition> attributeDefinitions() {
        return this.attributeDefinitions;
    }

    public String tableName() {
        return this.tableName;
    }

    public ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates() {
        return this.globalSecondaryIndexUpdates;
    }

    public StreamSpecification streamSpecification() {
        return this.streamSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalSecondaryIndexUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSpecification());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest)((Object)obj);
        return Objects.equals(this.attributeDefinitions(), other.attributeDefinitions()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && Objects.equals(this.globalSecondaryIndexUpdates(), other.globalSecondaryIndexUpdates()) && Objects.equals(this.streamSpecification(), other.streamSpecification());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attributeDefinitions() != null) {
            sb.append("AttributeDefinitions: ").append(this.attributeDefinitions()).append(",");
        }
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.provisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(this.provisionedThroughput()).append(",");
        }
        if (this.globalSecondaryIndexUpdates() != null) {
            sb.append("GlobalSecondaryIndexUpdates: ").append(this.globalSecondaryIndexUpdates()).append(",");
        }
        if (this.streamSpecification() != null) {
            sb.append("StreamSpecification: ").append(this.streamSpecification()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeDefinitions": {
                return Optional.of(clazz.cast(this.attributeDefinitions()));
            }
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "ProvisionedThroughput": {
                return Optional.of(clazz.cast(this.provisionedThroughput()));
            }
            case "GlobalSecondaryIndexUpdates": {
                return Optional.of(clazz.cast(this.globalSecondaryIndexUpdates()));
            }
            case "StreamSpecification": {
                return Optional.of(clazz.cast(this.streamSpecification()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeDefinition> attributeDefinitions;
        private String tableName;
        private ProvisionedThroughput provisionedThroughput;
        private List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;
        private StreamSpecification streamSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            this.attributeDefinitions(model.attributeDefinitions);
            this.tableName(model.tableName);
            this.provisionedThroughput(model.provisionedThroughput);
            this.globalSecondaryIndexUpdates(model.globalSecondaryIndexUpdates);
            this.streamSpecification(model.streamSpecification);
        }

        public final Collection<AttributeDefinition.Builder> getAttributeDefinitions() {
            return this.attributeDefinitions != null ? (Collection)this.attributeDefinitions.stream().map(AttributeDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition ... attributeDefinitions) {
            this.attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final Collection<GlobalSecondaryIndexUpdate.Builder> getGlobalSecondaryIndexUpdates() {
            return this.globalSecondaryIndexUpdates != null ? (Collection)this.globalSecondaryIndexUpdates.stream().map(GlobalSecondaryIndexUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copy(globalSecondaryIndexUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate ... globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates(Arrays.asList(globalSecondaryIndexUpdates));
            return this;
        }

        public final void setGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate.BuilderImpl> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copyFromBuilder(globalSecondaryIndexUpdates);
        }

        public final StreamSpecification.Builder getStreamSpecification() {
            return this.streamSpecification != null ? this.streamSpecification.toBuilder() : null;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final void setStreamSpecification(StreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateTableRequest> {
        public Builder attributeDefinitions(Collection<AttributeDefinition> var1);

        public Builder attributeDefinitions(AttributeDefinition ... var1);

        public Builder tableName(String var1);

        public Builder provisionedThroughput(ProvisionedThroughput var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().apply(provisionedThroughput)).build());
        }

        public Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> var1);

        public Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate ... var1);

        public Builder streamSpecification(StreamSpecification var1);

        default public Builder streamSpecification(Consumer<StreamSpecification.Builder> streamSpecification) {
            return this.streamSpecification((StreamSpecification)((StreamSpecification.Builder)StreamSpecification.builder().apply(streamSpecification)).build());
        }
    }
}

