/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DeleteItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteItemResponse extends DynamoDBResponse implements
        ToCopyableBuilder<DeleteItemResponse.Builder, DeleteItemResponse> {
    private final Map<String, AttributeValue> attributes;

    private final ConsumedCapacity consumedCapacity;

    private final ItemCollectionMetrics itemCollectionMetrics;

    private DeleteItemResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.consumedCapacity = builder.consumedCapacity;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
    }

    /**
     * <p>
     * A map of attribute names to <code>AttributeValue</code> objects, representing the item as it appeared before the
     * <code>DeleteItem</code> operation. This map appears in the response only if <code>ReturnValues</code> was
     * specified as <code>ALL_OLD</code> in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of attribute names to <code>AttributeValue</code> objects, representing the item as it appeared
     *         before the <code>DeleteItem</code> operation. This map appears in the response only if
     *         <code>ReturnValues</code> was specified as <code>ALL_OLD</code> in the request.
     */
    public Map<String, AttributeValue> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The capacity units consumed by the <code>DeleteItem</code> operation. The data returned includes the total
     * provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation.
     * <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was
     * specified. For more information, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
     * >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The capacity units consumed by the <code>DeleteItem</code> operation. The data returned includes the
     *         total provisioned throughput consumed, along with statistics for the table and any indexes involved in
     *         the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
     *         parameter was specified. For more information, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
     *         >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public ConsumedCapacity consumedCapacity() {
        return consumedCapacity;
    }

    /**
     * <p>
     * Information about item collections, if any, that were affected by the <code>DeleteItem</code> operation.
     * <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter was
     * specified. If the table does not have any local secondary indexes, this information is not returned in the
     * response.
     * </p>
     * <p>
     * Each <code>ItemCollectionMetrics</code> element consists of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
     * partition key value of the item itself.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SizeEstimateRange</code> - An estimate of item collection size, in gigabytes. This value is a two-element
     * array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the
     * items in the table, plus the size of all attributes projected into all of the local secondary indexes on that
     * table. Use this estimate to measure whether a local secondary index is approaching its size limit.
     * </p>
     * <p>
     * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about item collections, if any, that were affected by the <code>DeleteItem</code> operation.
     *         <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code>
     *         parameter was specified. If the table does not have any local secondary indexes, this information is not
     *         returned in the response.</p>
     *         <p>
     *         Each <code>ItemCollectionMetrics</code> element consists of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
     *         partition key value of the item itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SizeEstimateRange</code> - An estimate of item collection size, in gigabytes. This value is a
     *         two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the
     *         size of all the items in the table, plus the size of all attributes projected into all of the local
     *         secondary indexes on that table. Use this estimate to measure whether a local secondary index is
     *         approaching its size limit.
     *         </p>
     *         <p>
     *         The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
     *         estimate.
     *         </p>
     *         </li>
     */
    public ItemCollectionMetrics itemCollectionMetrics() {
        return itemCollectionMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(consumedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(itemCollectionMetrics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteItemResponse)) {
            return false;
        }
        DeleteItemResponse other = (DeleteItemResponse) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(consumedCapacity(), other.consumedCapacity())
                && Objects.equals(itemCollectionMetrics(), other.itemCollectionMetrics());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        if (consumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(consumedCapacity()).append(",");
        }
        if (itemCollectionMetrics() != null) {
            sb.append("ItemCollectionMetrics: ").append(itemCollectionMetrics()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.of(clazz.cast(attributes()));
        case "ConsumedCapacity":
            return Optional.of(clazz.cast(consumedCapacity()));
        case "ItemCollectionMetrics":
            return Optional.of(clazz.cast(itemCollectionMetrics()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDBResponse.Builder, CopyableBuilder<Builder, DeleteItemResponse> {
        /**
         * <p>
         * A map of attribute names to <code>AttributeValue</code> objects, representing the item as it appeared before
         * the <code>DeleteItem</code> operation. This map appears in the response only if <code>ReturnValues</code> was
         * specified as <code>ALL_OLD</code> in the request.
         * </p>
         * 
         * @param attributes
         *        A map of attribute names to <code>AttributeValue</code> objects, representing the item as it appeared
         *        before the <code>DeleteItem</code> operation. This map appears in the response only if
         *        <code>ReturnValues</code> was specified as <code>ALL_OLD</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, AttributeValue> attributes);

        /**
         * <p>
         * The capacity units consumed by the <code>DeleteItem</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified. For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         * >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the <code>DeleteItem</code> operation. The data returned includes the
         *        total provisioned throughput consumed, along with statistics for the table and any indexes involved in
         *        the operation. <code>ConsumedCapacity</code> is only returned if the
         *        <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         *        >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity consumedCapacity);

        /**
         * <p>
         * The capacity units consumed by the <code>DeleteItem</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified. For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         * >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link ConsumedCapacity.Builder} avoiding the need to
         * create one manually via {@link ConsumedCapacity#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConsumedCapacity.Builder#build()} is called immediately and its
         * result is passed to {@link #consumedCapacity(ConsumedCapacity)}.
         * 
         * @param consumedCapacity
         *        a consumer that will call methods on {@link ConsumedCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedCapacity(ConsumedCapacity)
         */
        default Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> consumedCapacity) {
            return consumedCapacity(ConsumedCapacity.builder().apply(consumedCapacity).build());
        }

        /**
         * <p>
         * Information about item collections, if any, that were affected by the <code>DeleteItem</code> operation.
         * <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter
         * was specified. If the table does not have any local secondary indexes, this information is not returned in
         * the response.
         * </p>
         * <p>
         * Each <code>ItemCollectionMetrics</code> element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
         * partition key value of the item itself.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SizeEstimateRange</code> - An estimate of item collection size, in gigabytes. This value is a
         * two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the
         * size of all the items in the table, plus the size of all attributes projected into all of the local secondary
         * indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size
         * limit.
         * </p>
         * <p>
         * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
         * estimate.
         * </p>
         * </li>
         * </ul>
         * 
         * @param itemCollectionMetrics
         *        Information about item collections, if any, that were affected by the <code>DeleteItem</code>
         *        operation. <code>ItemCollectionMetrics</code> is only returned if the
         *        <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table does not have any local
         *        secondary indexes, this information is not returned in the response.</p>
         *        <p>
         *        Each <code>ItemCollectionMetrics</code> element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as
         *        the partition key value of the item itself.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SizeEstimateRange</code> - An estimate of item collection size, in gigabytes. This value is a
         *        two-element array containing a lower bound and an upper bound for the estimate. The estimate includes
         *        the size of all the items in the table, plus the size of all attributes projected into all of the
         *        local secondary indexes on that table. Use this estimate to measure whether a local secondary index is
         *        approaching its size limit.
         *        </p>
         *        <p>
         *        The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of
         *        the estimate.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics);

        /**
         * <p>
         * Information about item collections, if any, that were affected by the <code>DeleteItem</code> operation.
         * <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter
         * was specified. If the table does not have any local secondary indexes, this information is not returned in
         * the response.
         * </p>
         * <p>
         * Each <code>ItemCollectionMetrics</code> element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
         * partition key value of the item itself.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SizeEstimateRange</code> - An estimate of item collection size, in gigabytes. This value is a
         * two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the
         * size of all the items in the table, plus the size of all attributes projected into all of the local secondary
         * indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size
         * limit.
         * </p>
         * <p>
         * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
         * estimate.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link ItemCollectionMetrics.Builder} avoiding the need
         * to create one manually via {@link ItemCollectionMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link ItemCollectionMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #itemCollectionMetrics(ItemCollectionMetrics)}.
         * 
         * @param itemCollectionMetrics
         *        a consumer that will call methods on {@link ItemCollectionMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemCollectionMetrics(ItemCollectionMetrics)
         */
        default Builder itemCollectionMetrics(Consumer<ItemCollectionMetrics.Builder> itemCollectionMetrics) {
            return itemCollectionMetrics(ItemCollectionMetrics.builder().apply(itemCollectionMetrics).build());
        }
    }

    static final class BuilderImpl extends DynamoDBResponse.BuilderImpl implements Builder {
        private Map<String, AttributeValue> attributes;

        private ConsumedCapacity consumedCapacity;

        private ItemCollectionMetrics itemCollectionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteItemResponse model) {
            attributes(model.attributes);
            consumedCapacity(model.consumedCapacity);
            itemCollectionMetrics(model.itemCollectionMetrics);
        }

        public final Map<String, AttributeValue.Builder> getAttributes() {
            return attributes != null ? CollectionUtils.mapValues(attributes, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder attributes(Map<String, AttributeValue> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, AttributeValue.BuilderImpl> attributes) {
            this.attributes = AttributeMapCopier.copyFromBuilder(attributes);
        }

        public final ConsumedCapacity.Builder getConsumedCapacity() {
            return consumedCapacity != null ? consumedCapacity.toBuilder() : null;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final void setConsumedCapacity(ConsumedCapacity.BuilderImpl consumedCapacity) {
            this.consumedCapacity = consumedCapacity != null ? consumedCapacity.build() : null;
        }

        public final ItemCollectionMetrics.Builder getItemCollectionMetrics() {
            return itemCollectionMetrics != null ? itemCollectionMetrics.toBuilder() : null;
        }

        @Override
        public final Builder itemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics;
            return this;
        }

        public final void setItemCollectionMetrics(ItemCollectionMetrics.BuilderImpl itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics != null ? itemCollectionMetrics.build() : null;
        }

        @Override
        public DeleteItemResponse build() {
            return new DeleteItemResponse(this);
        }
    }
}
