/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ListStreams</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStreamsRequest extends DynamoDBStreamsRequest implements
        ToCopyableBuilder<ListStreamsRequest.Builder, ListStreamsRequest> {
    private final String tableName;

    private final Integer limit;

    private final String exclusiveStartStreamArn;

    private ListStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.limit = builder.limit;
        this.exclusiveStartStreamArn = builder.exclusiveStartStreamArn;
    }

    /**
     * <p>
     * If this parameter is provided, then only the streams associated with this table name are returned.
     * </p>
     * 
     * @return If this parameter is provided, then only the streams associated with this table name are returned.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The maximum number of streams to return. The upper limit is 100.
     * </p>
     * 
     * @return The maximum number of streams to return. The upper limit is 100.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the first item that this operation will evaluate. Use the value that was
     * returned for <code>LastEvaluatedStreamArn</code> in the previous operation.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the first item that this operation will evaluate. Use the value that
     *         was returned for <code>LastEvaluatedStreamArn</code> in the previous operation.
     */
    public String exclusiveStartStreamArn() {
        return exclusiveStartStreamArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartStreamArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsRequest)) {
            return false;
        }
        ListStreamsRequest other = (ListStreamsRequest) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(limit(), other.limit())
                && Objects.equals(exclusiveStartStreamArn(), other.exclusiveStartStreamArn());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (exclusiveStartStreamArn() != null) {
            sb.append("ExclusiveStartStreamArn: ").append(exclusiveStartStreamArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.of(clazz.cast(tableName()));
        case "Limit":
            return Optional.of(clazz.cast(limit()));
        case "ExclusiveStartStreamArn":
            return Optional.of(clazz.cast(exclusiveStartStreamArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDBStreamsRequest.Builder, CopyableBuilder<Builder, ListStreamsRequest> {
        /**
         * <p>
         * If this parameter is provided, then only the streams associated with this table name are returned.
         * </p>
         * 
         * @param tableName
         *        If this parameter is provided, then only the streams associated with this table name are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The maximum number of streams to return. The upper limit is 100.
         * </p>
         * 
         * @param limit
         *        The maximum number of streams to return. The upper limit is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the first item that this operation will evaluate. Use the value that was
         * returned for <code>LastEvaluatedStreamArn</code> in the previous operation.
         * </p>
         * 
         * @param exclusiveStartStreamArn
         *        The ARN (Amazon Resource Name) of the first item that this operation will evaluate. Use the value that
         *        was returned for <code>LastEvaluatedStreamArn</code> in the previous operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartStreamArn(String exclusiveStartStreamArn);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends DynamoDBStreamsRequest.BuilderImpl implements Builder {
        private String tableName;

        private Integer limit;

        private String exclusiveStartStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsRequest model) {
            tableName(model.tableName);
            limit(model.limit);
            exclusiveStartStreamArn(model.exclusiveStartStreamArn);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartStreamArn() {
            return exclusiveStartStreamArn;
        }

        @Override
        public final Builder exclusiveStartStreamArn(String exclusiveStartStreamArn) {
            this.exclusiveStartStreamArn = exclusiveStartStreamArn;
            return this;
        }

        public final void setExclusiveStartStreamArn(String exclusiveStartStreamArn) {
            this.exclusiveStartStreamArn = exclusiveStartStreamArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListStreamsRequest build() {
            return new ListStreamsRequest(this);
        }
    }
}
