/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.PutRequestMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to perform a <code>PutItem</code> operation on an item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutRequest implements StructuredPojo, ToCopyableBuilder<PutRequest.Builder, PutRequest> {
    private final Map<String, AttributeValue> item;

    private PutRequest(BuilderImpl builder) {
        this.item = builder.item;
    }

    /**
     * <p>
     * A map of attribute name to attribute values, representing the primary key of an item to be processed by
     * <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must
     * match those of the table's key schema. If any attributes are present in the item which are part of an index key
     * schema for the table, their types must match the index key schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of attribute name to attribute values, representing the primary key of an item to be processed by
     *         <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types
     *         must match those of the table's key schema. If any attributes are present in the item which are part of
     *         an index key schema for the table, their types must match the index key schema.
     */
    public Map<String, AttributeValue> item() {
        return item;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(item());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRequest)) {
            return false;
        }
        PutRequest other = (PutRequest) obj;
        return Objects.equals(item(), other.item());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (item() != null) {
            sb.append("Item: ").append(item()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.of(clazz.cast(item()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PutRequest> {
        /**
         * <p>
         * A map of attribute name to attribute values, representing the primary key of an item to be processed by
         * <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must
         * match those of the table's key schema. If any attributes are present in the item which are part of an index
         * key schema for the table, their types must match the index key schema.
         * </p>
         * 
         * @param item
         *        A map of attribute name to attribute values, representing the primary key of an item to be processed
         *        by <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data
         *        types must match those of the table's key schema. If any attributes are present in the item which are
         *        part of an index key schema for the table, their types must match the index key schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Map<String, AttributeValue> item);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, AttributeValue> item;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRequest model) {
            item(model.item);
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            return item != null ? CollectionUtils.mapValues(item, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
            return this;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = PutItemInputAttributeMapCopier.copyFromBuilder(item);
        }

        @Override
        public PutRequest build() {
            return new PutRequest(this);
        }
    }
}
