/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.ShardMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A uniquely identified group of stream records within a stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Shard implements StructuredPojo, ToCopyableBuilder<Shard.Builder, Shard> {
    private final String shardId;

    private final SequenceNumberRange sequenceNumberRange;

    private final String parentShardId;

    private Shard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.sequenceNumberRange = builder.sequenceNumberRange;
        this.parentShardId = builder.parentShardId;
    }

    /**
     * <p>
     * The system-generated identifier for this shard.
     * </p>
     * 
     * @return The system-generated identifier for this shard.
     */
    public String shardId() {
        return shardId;
    }

    /**
     * <p>
     * The range of possible sequence numbers for the shard.
     * </p>
     * 
     * @return The range of possible sequence numbers for the shard.
     */
    public SequenceNumberRange sequenceNumberRange() {
        return sequenceNumberRange;
    }

    /**
     * <p>
     * The shard ID of the current shard's parent.
     * </p>
     * 
     * @return The shard ID of the current shard's parent.
     */
    public String parentShardId() {
        return parentShardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shardId());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumberRange());
        hashCode = 31 * hashCode + Objects.hashCode(parentShardId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard) obj;
        return Objects.equals(shardId(), other.shardId()) && Objects.equals(sequenceNumberRange(), other.sequenceNumberRange())
                && Objects.equals(parentShardId(), other.parentShardId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (shardId() != null) {
            sb.append("ShardId: ").append(shardId()).append(",");
        }
        if (sequenceNumberRange() != null) {
            sb.append("SequenceNumberRange: ").append(sequenceNumberRange()).append(",");
        }
        if (parentShardId() != null) {
            sb.append("ParentShardId: ").append(parentShardId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardId":
            return Optional.of(clazz.cast(shardId()));
        case "SequenceNumberRange":
            return Optional.of(clazz.cast(sequenceNumberRange()));
        case "ParentShardId":
            return Optional.of(clazz.cast(parentShardId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Shard> {
        /**
         * <p>
         * The system-generated identifier for this shard.
         * </p>
         * 
         * @param shardId
         *        The system-generated identifier for this shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * The range of possible sequence numbers for the shard.
         * </p>
         * 
         * @param sequenceNumberRange
         *        The range of possible sequence numbers for the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange);

        /**
         * <p>
         * The range of possible sequence numbers for the shard.
         * </p>
         * This is a convenience that creates an instance of the {@link SequenceNumberRange.Builder} avoiding the need
         * to create one manually via {@link SequenceNumberRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link SequenceNumberRange.Builder#build()} is called immediately and
         * its result is passed to {@link #sequenceNumberRange(SequenceNumberRange)}.
         * 
         * @param sequenceNumberRange
         *        a consumer that will call methods on {@link SequenceNumberRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sequenceNumberRange(SequenceNumberRange)
         */
        default Builder sequenceNumberRange(Consumer<SequenceNumberRange.Builder> sequenceNumberRange) {
            return sequenceNumberRange(SequenceNumberRange.builder().apply(sequenceNumberRange).build());
        }

        /**
         * <p>
         * The shard ID of the current shard's parent.
         * </p>
         * 
         * @param parentShardId
         *        The shard ID of the current shard's parent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentShardId(String parentShardId);
    }

    static final class BuilderImpl implements Builder {
        private String shardId;

        private SequenceNumberRange sequenceNumberRange;

        private String parentShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(Shard model) {
            shardId(model.shardId);
            sequenceNumberRange(model.sequenceNumberRange);
            parentShardId(model.parentShardId);
        }

        public final String getShardId() {
            return shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final SequenceNumberRange.Builder getSequenceNumberRange() {
            return sequenceNumberRange != null ? sequenceNumberRange.toBuilder() : null;
        }

        @Override
        public final Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
            return this;
        }

        public final void setSequenceNumberRange(SequenceNumberRange.BuilderImpl sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange != null ? sequenceNumberRange.build() : null;
        }

        public final String getParentShardId() {
            return parentShardId;
        }

        @Override
        public final Builder parentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
            return this;
        }

        public final void setParentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
        }

        @Override
        public Shard build() {
            return new Shard(this);
        }
    }
}
