/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.TimeToLiveDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the Time to Live (TTL) status on the specified table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TimeToLiveDescription implements StructuredPojo,
        ToCopyableBuilder<TimeToLiveDescription.Builder, TimeToLiveDescription> {
    private final String timeToLiveStatus;

    private final String attributeName;

    private TimeToLiveDescription(BuilderImpl builder) {
        this.timeToLiveStatus = builder.timeToLiveStatus;
        this.attributeName = builder.attributeName;
    }

    /**
     * <p>
     * The Time to Live status for the table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeToLiveStatus}
     * will return {@link TimeToLiveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeToLiveStatusString}.
     * </p>
     * 
     * @return The Time to Live status for the table.
     * @see TimeToLiveStatus
     */
    public TimeToLiveStatus timeToLiveStatus() {
        return TimeToLiveStatus.fromValue(timeToLiveStatus);
    }

    /**
     * <p>
     * The Time to Live status for the table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeToLiveStatus}
     * will return {@link TimeToLiveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeToLiveStatusString}.
     * </p>
     * 
     * @return The Time to Live status for the table.
     * @see TimeToLiveStatus
     */
    public String timeToLiveStatusString() {
        return timeToLiveStatus;
    }

    /**
     * <p>
     * The name of the Time to Live attribute for items in the table.
     * </p>
     * 
     * @return The name of the Time to Live attribute for items in the table.
     */
    public String attributeName() {
        return attributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeToLiveStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeToLiveDescription)) {
            return false;
        }
        TimeToLiveDescription other = (TimeToLiveDescription) obj;
        return Objects.equals(timeToLiveStatusString(), other.timeToLiveStatusString())
                && Objects.equals(attributeName(), other.attributeName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (timeToLiveStatusString() != null) {
            sb.append("TimeToLiveStatus: ").append(timeToLiveStatusString()).append(",");
        }
        if (attributeName() != null) {
            sb.append("AttributeName: ").append(attributeName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeToLiveStatus":
            return Optional.of(clazz.cast(timeToLiveStatusString()));
        case "AttributeName":
            return Optional.of(clazz.cast(attributeName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeToLiveDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TimeToLiveDescription> {
        /**
         * <p>
         * The Time to Live status for the table.
         * </p>
         * 
         * @param timeToLiveStatus
         *        The Time to Live status for the table.
         * @see TimeToLiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeToLiveStatus
         */
        Builder timeToLiveStatus(String timeToLiveStatus);

        /**
         * <p>
         * The Time to Live status for the table.
         * </p>
         * 
         * @param timeToLiveStatus
         *        The Time to Live status for the table.
         * @see TimeToLiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeToLiveStatus
         */
        Builder timeToLiveStatus(TimeToLiveStatus timeToLiveStatus);

        /**
         * <p>
         * The name of the Time to Live attribute for items in the table.
         * </p>
         * 
         * @param attributeName
         *        The name of the Time to Live attribute for items in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);
    }

    static final class BuilderImpl implements Builder {
        private String timeToLiveStatus;

        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeToLiveDescription model) {
            timeToLiveStatus(model.timeToLiveStatus);
            attributeName(model.attributeName);
        }

        public final String getTimeToLiveStatus() {
            return timeToLiveStatus;
        }

        @Override
        public final Builder timeToLiveStatus(String timeToLiveStatus) {
            this.timeToLiveStatus = timeToLiveStatus;
            return this;
        }

        @Override
        public final Builder timeToLiveStatus(TimeToLiveStatus timeToLiveStatus) {
            this.timeToLiveStatus(timeToLiveStatus.toString());
            return this;
        }

        public final void setTimeToLiveStatus(String timeToLiveStatus) {
            this.timeToLiveStatus = timeToLiveStatus;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public TimeToLiveDescription build() {
            return new TimeToLiveDescription(this);
        }
    }
}
