/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateTimeToLiveResponse extends DynamoDBResponse implements
        ToCopyableBuilder<UpdateTimeToLiveResponse.Builder, UpdateTimeToLiveResponse> {
    private final TimeToLiveSpecification timeToLiveSpecification;

    private UpdateTimeToLiveResponse(BuilderImpl builder) {
        super(builder);
        this.timeToLiveSpecification = builder.timeToLiveSpecification;
    }

    /**
     * <p>
     * Represents the output of an <code>UpdateTimeToLive</code> operation.
     * </p>
     * 
     * @return Represents the output of an <code>UpdateTimeToLive</code> operation.
     */
    public TimeToLiveSpecification timeToLiveSpecification() {
        return timeToLiveSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeToLiveSpecification());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTimeToLiveResponse)) {
            return false;
        }
        UpdateTimeToLiveResponse other = (UpdateTimeToLiveResponse) obj;
        return Objects.equals(timeToLiveSpecification(), other.timeToLiveSpecification());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (timeToLiveSpecification() != null) {
            sb.append("TimeToLiveSpecification: ").append(timeToLiveSpecification()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeToLiveSpecification":
            return Optional.of(clazz.cast(timeToLiveSpecification()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDBResponse.Builder, CopyableBuilder<Builder, UpdateTimeToLiveResponse> {
        /**
         * <p>
         * Represents the output of an <code>UpdateTimeToLive</code> operation.
         * </p>
         * 
         * @param timeToLiveSpecification
         *        Represents the output of an <code>UpdateTimeToLive</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification);

        /**
         * <p>
         * Represents the output of an <code>UpdateTimeToLive</code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeToLiveSpecification.Builder} avoiding the
         * need to create one manually via {@link TimeToLiveSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeToLiveSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #timeToLiveSpecification(TimeToLiveSpecification)}.
         * 
         * @param timeToLiveSpecification
         *        a consumer that will call methods on {@link TimeToLiveSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeToLiveSpecification(TimeToLiveSpecification)
         */
        default Builder timeToLiveSpecification(Consumer<TimeToLiveSpecification.Builder> timeToLiveSpecification) {
            return timeToLiveSpecification(TimeToLiveSpecification.builder().apply(timeToLiveSpecification).build());
        }
    }

    static final class BuilderImpl extends DynamoDBResponse.BuilderImpl implements Builder {
        private TimeToLiveSpecification timeToLiveSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTimeToLiveResponse model) {
            timeToLiveSpecification(model.timeToLiveSpecification);
        }

        public final TimeToLiveSpecification.Builder getTimeToLiveSpecification() {
            return timeToLiveSpecification != null ? timeToLiveSpecification.toBuilder() : null;
        }

        @Override
        public final Builder timeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        public final void setTimeToLiveSpecification(TimeToLiveSpecification.BuilderImpl timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification != null ? timeToLiveSpecification.build() : null;
        }

        @Override
        public UpdateTimeToLiveResponse build() {
            return new UpdateTimeToLiveResponse(this);
        }
    }
}
