/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * KeysAndAttributes JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class KeysAndAttributesUnmarshaller implements Unmarshaller<KeysAndAttributes, JsonUnmarshallerContext> {

    public KeysAndAttributes unmarshall(JsonUnmarshallerContext context) throws Exception {
        KeysAndAttributes.Builder keysAndAttributesBuilder = KeysAndAttributes.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Keys", targetDepth)) {
                    context.nextToken();
                    keysAndAttributesBuilder.keys(new ListUnmarshaller<java.util.Map<String, AttributeValue>>(
                            new MapUnmarshaller<String, AttributeValue>(context.getUnmarshaller(String.class),
                                    AttributeValueUnmarshaller.getInstance())).unmarshall(context));
                }
                if (context.testExpression("AttributesToGet", targetDepth)) {
                    context.nextToken();
                    keysAndAttributesBuilder.attributesToGet(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("ConsistentRead", targetDepth)) {
                    context.nextToken();
                    keysAndAttributesBuilder.consistentRead(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("ProjectionExpression", targetDepth)) {
                    context.nextToken();
                    keysAndAttributesBuilder.projectionExpression(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ExpressionAttributeNames", targetDepth)) {
                    context.nextToken();
                    keysAndAttributesBuilder.expressionAttributeNames(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return keysAndAttributesBuilder.build();
    }

    private static final KeysAndAttributesUnmarshaller INSTANCE = new KeysAndAttributesUnmarshaller();

    public static KeysAndAttributesUnmarshaller getInstance() {
        return INSTANCE;
    }
}
