/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.Projection;

@SdkInternalApi
public class ProjectionMarshaller {
    private static final MarshallingInfo<String> PROJECTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProjectionType").build();
    private static final MarshallingInfo<List> NONKEYATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NonKeyAttributes").build();
    private static final ProjectionMarshaller INSTANCE = new ProjectionMarshaller();

    public static ProjectionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Projection projection, ProtocolMarshaller protocolMarshaller) {
        if (projection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)projection.projectionTypeString(), PROJECTIONTYPE_BINDING);
            protocolMarshaller.marshall(projection.nonKeyAttributes(), NONKEYATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

