/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetRecords</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetRecordsResponse extends DynamoDBStreamsResponse implements
        ToCopyableBuilder<GetRecordsResponse.Builder, GetRecordsResponse> {
    private final List<Record> records;

    private final String nextShardIterator;

    private GetRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.nextShardIterator = builder.nextShardIterator;
    }

    /**
     * <p>
     * The stream records from the shard, which were retrieved using the shard iterator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The stream records from the shard, which were retrieved using the shard iterator.
     */
    public List<Record> records() {
        return records;
    }

    /**
     * <p>
     * The next position in the shard from which to start sequentially reading stream records. If set to
     * <code>null</code>, the shard has been closed and the requested iterator will not return any more data.
     * </p>
     * 
     * @return The next position in the shard from which to start sequentially reading stream records. If set to
     *         <code>null</code>, the shard has been closed and the requested iterator will not return any more data.
     */
    public String nextShardIterator() {
        return nextShardIterator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(records());
        hashCode = 31 * hashCode + Objects.hashCode(nextShardIterator());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResponse)) {
            return false;
        }
        GetRecordsResponse other = (GetRecordsResponse) obj;
        return Objects.equals(records(), other.records()) && Objects.equals(nextShardIterator(), other.nextShardIterator());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRecordsResponse").add("Records", records()).add("NextShardIterator", nextShardIterator())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Records":
            return Optional.of(clazz.cast(records()));
        case "NextShardIterator":
            return Optional.of(clazz.cast(nextShardIterator()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDBStreamsResponse.Builder, CopyableBuilder<Builder, GetRecordsResponse> {
        /**
         * <p>
         * The stream records from the shard, which were retrieved using the shard iterator.
         * </p>
         * 
         * @param records
         *        The stream records from the shard, which were retrieved using the shard iterator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * <p>
         * The stream records from the shard, which were retrieved using the shard iterator.
         * </p>
         * 
         * @param records
         *        The stream records from the shard, which were retrieved using the shard iterator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);

        /**
         * <p>
         * The next position in the shard from which to start sequentially reading stream records. If set to
         * <code>null</code>, the shard has been closed and the requested iterator will not return any more data.
         * </p>
         * 
         * @param nextShardIterator
         *        The next position in the shard from which to start sequentially reading stream records. If set to
         *        <code>null</code>, the shard has been closed and the requested iterator will not return any more data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextShardIterator(String nextShardIterator);
    }

    static final class BuilderImpl extends DynamoDBStreamsResponse.BuilderImpl implements Builder {
        private List<Record> records;

        private String nextShardIterator;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsResponse model) {
            records(model.records);
            nextShardIterator(model.nextShardIterator);
        }

        public final Collection<Record.Builder> getRecords() {
            return records != null ? records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record... records) {
            records(Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        public final String getNextShardIterator() {
            return nextShardIterator;
        }

        @Override
        public final Builder nextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
            return this;
        }

        public final void setNextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
        }

        @Override
        public GetRecordsResponse build() {
            return new GetRecordsResponse(this);
        }
    }
}
