/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.dynamodb.model.BinarySetAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.ListAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.MapAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.NumberSetAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.StringSetAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.transform.AttributeValueMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttributeValue
implements StructuredPojo,
ToCopyableBuilder<Builder, AttributeValue> {
    private final String s;
    private final String n;
    private final ByteBuffer b;
    private final List<String> ss;
    private final List<String> ns;
    private final List<ByteBuffer> bs;
    private final Map<String, AttributeValue> m;
    private final List<AttributeValue> l;
    private final Boolean bool;
    private final Boolean nul;

    private AttributeValue(BuilderImpl builder) {
        this.s = builder.s;
        this.n = builder.n;
        this.b = builder.b;
        this.ss = builder.ss;
        this.ns = builder.ns;
        this.bs = builder.bs;
        this.m = builder.m;
        this.l = builder.l;
        this.bool = builder.bool;
        this.nul = builder.nul;
    }

    public String s() {
        return this.s;
    }

    public String n() {
        return this.n;
    }

    public ByteBuffer b() {
        return this.b == null ? null : this.b.asReadOnlyBuffer();
    }

    public List<String> ss() {
        return this.ss;
    }

    public List<String> ns() {
        return this.ns;
    }

    public List<ByteBuffer> bs() {
        return this.bs;
    }

    public Map<String, AttributeValue> m() {
        return this.m;
    }

    public List<AttributeValue> l() {
        return this.l;
    }

    public Boolean bool() {
        return this.bool;
    }

    public Boolean nul() {
        return this.nul;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s());
        hashCode = 31 * hashCode + Objects.hashCode(this.n());
        hashCode = 31 * hashCode + Objects.hashCode(this.b());
        hashCode = 31 * hashCode + Objects.hashCode(this.ss());
        hashCode = 31 * hashCode + Objects.hashCode(this.ns());
        hashCode = 31 * hashCode + Objects.hashCode(this.bs());
        hashCode = 31 * hashCode + Objects.hashCode(this.m());
        hashCode = 31 * hashCode + Objects.hashCode(this.l());
        hashCode = 31 * hashCode + Objects.hashCode(this.bool());
        hashCode = 31 * hashCode + Objects.hashCode(this.nul());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue)obj;
        return Objects.equals(this.s(), other.s()) && Objects.equals(this.n(), other.n()) && Objects.equals(this.b(), other.b()) && Objects.equals(this.ss(), other.ss()) && Objects.equals(this.ns(), other.ns()) && Objects.equals(this.bs(), other.bs()) && Objects.equals(this.m(), other.m()) && Objects.equals(this.l(), other.l()) && Objects.equals(this.bool(), other.bool()) && Objects.equals(this.nul(), other.nul());
    }

    public String toString() {
        return ToString.builder((String)"AttributeValue").add("S", (Object)this.s()).add("N", (Object)this.n()).add("B", (Object)this.b()).add("SS", this.ss()).add("NS", this.ns()).add("BS", this.bs()).add("M", this.m()).add("L", this.l()).add("BOOL", (Object)this.bool()).add("NUL", (Object)this.nul()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S": {
                return Optional.of(clazz.cast(this.s()));
            }
            case "N": {
                return Optional.of(clazz.cast(this.n()));
            }
            case "B": {
                return Optional.of(clazz.cast(this.b()));
            }
            case "SS": {
                return Optional.of(clazz.cast(this.ss()));
            }
            case "NS": {
                return Optional.of(clazz.cast(this.ns()));
            }
            case "BS": {
                return Optional.of(clazz.cast(this.bs()));
            }
            case "M": {
                return Optional.of(clazz.cast(this.m()));
            }
            case "L": {
                return Optional.of(clazz.cast(this.l()));
            }
            case "BOOL": {
                return Optional.of(clazz.cast(this.bool()));
            }
            case "NUL": {
                return Optional.of(clazz.cast(this.nul()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String s;
        private String n;
        private ByteBuffer b;
        private List<String> ss;
        private List<String> ns;
        private List<ByteBuffer> bs;
        private Map<String, AttributeValue> m;
        private List<AttributeValue> l;
        private Boolean bool;
        private Boolean nul;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            this.s(model.s);
            this.n(model.n);
            this.b(model.b);
            this.ss(model.ss);
            this.ns(model.ns);
            this.bs(model.bs);
            this.m(model.m);
            this.l(model.l);
            this.bool(model.bool);
            this.nul(model.nul);
        }

        public final String getS() {
            return this.s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final void setS(String s) {
            this.s = s;
        }

        public final String getN() {
            return this.n;
        }

        @Override
        public final Builder n(String n) {
            this.n = n;
            return this;
        }

        public final void setN(String n) {
            this.n = n;
        }

        public final ByteBuffer getB() {
            return this.b;
        }

        @Override
        public final Builder b(ByteBuffer b) {
            this.b = StandardMemberCopier.copy((ByteBuffer)b);
            return this;
        }

        public final void setB(ByteBuffer b) {
            this.b = StandardMemberCopier.copy((ByteBuffer)b);
        }

        public final Collection<String> getSS() {
            return this.ss;
        }

        @Override
        public final Builder ss(Collection<String> ss) {
            this.ss = StringSetAttributeValueCopier.copy(ss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ss(String ... ss) {
            this.ss(Arrays.asList(ss));
            return this;
        }

        public final void setSS(Collection<String> ss) {
            this.ss = StringSetAttributeValueCopier.copy(ss);
        }

        public final Collection<String> getNS() {
            return this.ns;
        }

        @Override
        public final Builder ns(Collection<String> ns) {
            this.ns = NumberSetAttributeValueCopier.copy(ns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ns(String ... ns) {
            this.ns(Arrays.asList(ns));
            return this;
        }

        public final void setNS(Collection<String> ns) {
            this.ns = NumberSetAttributeValueCopier.copy(ns);
        }

        public final Collection<ByteBuffer> getBS() {
            return this.bs;
        }

        @Override
        public final Builder bs(Collection<ByteBuffer> bs) {
            this.bs = BinarySetAttributeValueCopier.copy(bs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bs(ByteBuffer ... bs) {
            this.bs(Arrays.asList(bs));
            return this;
        }

        public final void setBS(Collection<ByteBuffer> bs) {
            this.bs = BinarySetAttributeValueCopier.copy(bs);
        }

        public final Map<String, Builder> getM() {
            return this.m != null ? CollectionUtils.mapValues(this.m, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder m(Map<String, AttributeValue> m) {
            this.m = MapAttributeValueCopier.copy(m);
            return this;
        }

        public final void setM(Map<String, BuilderImpl> m) {
            this.m = MapAttributeValueCopier.copyFromBuilder(m);
        }

        public final Collection<Builder> getL() {
            return this.l != null ? (Collection)this.l.stream().map(AttributeValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder l(Collection<AttributeValue> l) {
            this.l = ListAttributeValueCopier.copy(l);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l(AttributeValue ... l) {
            this.l(Arrays.asList(l));
            return this;
        }

        public final void setL(Collection<BuilderImpl> l) {
            this.l = ListAttributeValueCopier.copyFromBuilder(l);
        }

        public final Boolean getBOOL() {
            return this.bool;
        }

        @Override
        public final Builder bool(Boolean bool) {
            this.bool = bool;
            return this;
        }

        public final void setBOOL(Boolean bool) {
            this.bool = bool;
        }

        public final Boolean getNUL() {
            return this.nul;
        }

        @Override
        public final Builder nul(Boolean nul) {
            this.nul = nul;
            return this;
        }

        public final void setNUL(Boolean nul) {
            this.nul = nul;
        }

        public AttributeValue build() {
            return new AttributeValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttributeValue> {
        public Builder s(String var1);

        public Builder n(String var1);

        public Builder b(ByteBuffer var1);

        public Builder ss(Collection<String> var1);

        public Builder ss(String ... var1);

        public Builder ns(Collection<String> var1);

        public Builder ns(String ... var1);

        public Builder bs(Collection<ByteBuffer> var1);

        public Builder bs(ByteBuffer ... var1);

        public Builder m(Map<String, AttributeValue> var1);

        public Builder l(Collection<AttributeValue> var1);

        public Builder l(AttributeValue ... var1);

        public Builder bool(Boolean var1);

        public Builder nul(Boolean var1);
    }
}

